/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.MergedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import de.lmu.ifi.dbs.elki.visualization.VisualizationProcessor;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.style.PropertiesBasedStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class VisualizerParameterizer {
    private static final Logging LOG = Logging.getLogger(VisualizerParameterizer.class);
    public static final int DEFAULT_SAMPLE_SIZE = 10000;
    private StyleLibrary stylelib;
    private Collection<VisualizationProcessor> factories;
    private int samplesize = -1;
    private RandomFactory rnd = RandomFactory.DEFAULT;

    public VisualizerParameterizer(int samplesize, StyleLibrary stylelib, Collection<VisualizationProcessor> factories) {
        this.samplesize = samplesize;
        this.stylelib = stylelib;
        this.factories = factories;
    }

    public VisualizerContext newContext(ResultHierarchy hier, Result start) {
        ArrayList<Relation> rels = ResultUtil.filterResults(hier, Relation.class);
        for (Relation rel : rels) {
            if (this.samplesize == 0 || !ResultUtil.filterResults(hier, rel, SamplingResult.class).isEmpty() || rel.size() <= this.samplesize) continue;
            SamplingResult sample = new SamplingResult(rel);
            sample.setSample(DBIDUtil.randomSample(sample.getSample(), this.samplesize, this.rnd));
            ResultUtil.addChildResult(rel, sample);
        }
        return new VisualizerContext(hier, start, this.stylelib, this.factories);
    }

    public static String getTitle(Database db, Result result) {
        ArrayList<TrackedParameter> settings = new ArrayList<TrackedParameter>();
        for (SettingsResult sr : SettingsResult.getSettingsResults(result)) {
            settings.addAll(sr.getSettings());
        }
        String algorithm = null;
        String distance = null;
        String dataset = null;
        for (TrackedParameter setting : settings) {
            String value;
            Parameter<?> param = setting.getParameter();
            OptionID option = param.getOptionID();
            String string = value = param.isDefined() ? param.getValueAsString() : null;
            if (option.equals(AlgorithmStep.Parameterizer.ALGORITHM_ID)) {
                algorithm = value;
            }
            if (option.equals(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID)) {
                distance = value;
            }
            if (!option.equals(FileBasedDatabaseConnection.Parameterizer.INPUT_ID)) continue;
            dataset = value;
        }
        StringBuilder buf = new StringBuilder();
        if (algorithm != null) {
            buf.append(VisualizerParameterizer.shortenClassname(algorithm.split(",")[0], '.'));
        }
        if (distance != null) {
            if (buf.length() > 0) {
                buf.append(" using ");
            }
            buf.append(VisualizerParameterizer.shortenClassname(distance, '.'));
        }
        if (dataset != null) {
            if (buf.length() > 0) {
                buf.append(" on ");
            }
            buf.append(VisualizerParameterizer.shortenClassname(dataset, File.separatorChar));
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    protected static String shortenClassname(String nam, char c) {
        int lastdot = nam.lastIndexOf(c);
        if (lastdot >= 0) {
            nam = nam.substring(lastdot + 1);
        }
        return nam;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLELIB_ID = new OptionID("visualizer.stylesheet", "Style properties file to use, included properties: classic, default, greyscale, neon, presentation, print");
        public static final OptionID ENABLEVIS_ID = new OptionID("vis.enable", "Visualizers to enable by default.");
        public static final OptionID SAMPLING_ID = new OptionID("vis.sampling", "Maximum number of objects to visualize by default (for performance reasons).");
        protected StyleLibrary stylelib = null;
        protected Pattern enableVisualizers = null;
        protected Collection<VisualizationProcessor> factories = null;
        protected int samplesize = -1;

        @Override
        protected void makeOptions(Parameterization config) {
            PatternParameter enablevisP;
            StringParameter stylelibP;
            super.makeOptions(config);
            IntParameter samplingP = (IntParameter)new IntParameter(SAMPLING_ID, 10000).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_MINUSONE_INT);
            if (config.grab(samplingP)) {
                this.samplesize = samplingP.intValue();
            }
            if (config.grab(stylelibP = new StringParameter(STYLELIB_ID, "default"))) {
                String filename = (String)stylelibP.getValue();
                try {
                    this.stylelib = new PropertiesBasedStyleLibrary(filename, filename);
                }
                catch (AbortException e) {
                    config.reportError(new WrongParameterValueException(stylelibP, filename, e.getMessage(), e));
                }
            }
            if (config.grab(enablevisP = (PatternParameter)new PatternParameter(ENABLEVIS_ID).setOptional(true)) && !"all".equals(enablevisP.getValueAsString())) {
                this.enableVisualizers = (Pattern)enablevisP.getValue();
            }
            MergedParameterization merged = new MergedParameterization(config);
            this.factories = Parameterizer.collectFactorys(merged, this.enableVisualizers);
        }

        private static <O> Collection<VisualizationProcessor> collectFactorys(MergedParameterization config, Pattern filter) {
            ArrayList<VisualizationProcessor> factories = new ArrayList<VisualizationProcessor>();
            for (Class<?> c : ELKIServiceRegistry.findAllImplementations(VisualizationProcessor.class)) {
                if (filter != null && !filter.matcher(c.getCanonicalName()).find()) continue;
                try {
                    config.rewind();
                    VisualizationProcessor a = ClassGenericsUtil.tryInstantiate(VisualizationProcessor.class, c, config);
                    factories.add(a);
                }
                catch (Throwable e) {
                    if (LOG.isDebugging()) {
                        LOG.exception("Error instantiating visualization processor " + c.getName(), e.getCause());
                        continue;
                    }
                    LOG.warning("Error instantiating visualization processor " + c.getName() + ": " + e.getMessage());
                }
            }
            return factories;
        }

        @Override
        protected VisualizerParameterizer makeInstance() {
            return new VisualizerParameterizer(this.samplesize, this.stylelib, this.factories);
        }
    }
}

