/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;

public final class BatikUtil {
    private BatikUtil() {
    }

    public static double[] getRelativeCoordinates(Event evt, Element reference) {
        if (evt instanceof DOMMouseEvent && reference instanceof SVGLocatable && reference instanceof SVGElement) {
            DOMMouseEvent gnme = (DOMMouseEvent)evt;
            SVGMatrix mat = ((SVGLocatable)((Object)reference)).getScreenCTM();
            SVGMatrix imat = mat.inverse();
            SVGPoint cPt = ((SVGElement)reference).getOwnerSVGElement().createSVGPoint();
            cPt.setX(gnme.getClientX());
            cPt.setY(gnme.getClientY());
            cPt = cPt.matrixTransform(imat);
            return new double[]{cPt.getX(), cPt.getY()};
        }
        return null;
    }

    public static boolean hasFOPInstalled() {
        try {
            Class<?> c1 = Class.forName("org.apache.fop.svg.PDFTranscoder");
            Class<?> c2 = Class.forName("org.apache.fop.render.ps.PSTranscoder");
            Class<?> c3 = Class.forName("org.apache.fop.render.ps.EPSTranscoder");
            return c1 != null && c2 != null && c3 != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

