/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGCloneVisible;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.util.Base64EncoderStream;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CloneInlineImages
extends SVGCloneVisible {
    @Override
    public Node cloneNode(Document doc, Node eold) {
        Element e;
        Node enew = null;
        if (eold instanceof Element && (e = (Element)eold).getTagName().equals("image")) {
            String url = e.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            ParsedURL urldata = new ParsedURL(url);
            if (ThumbnailRegistryEntry.isCompatibleURLStatic(urldata)) {
                enew = this.inlineThumbnail(doc, urldata, eold);
            } else if ("file".equals(urldata.getProtocol())) {
                enew = this.inlineExternal(doc, urldata, eold);
            }
        }
        if (enew != null) {
            return enew;
        }
        return super.cloneNode(doc, eold);
    }

    protected Node inlineThumbnail(Document doc, ParsedURL urldata, Node eold) {
        Filter img = ThumbnailRegistryEntry.handleURL(urldata);
        if (img == null) {
            LoggingUtil.warning("Image not found in registry: " + urldata.toString());
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write("data:image/png;base64,".getBytes());
            Base64EncoderStream encoder = new Base64EncoderStream(os);
            ImageIO.write(img.createDefaultRendering(), "png", encoder);
            encoder.close();
        }
        catch (IOException e) {
            LoggingUtil.exception("Exception serializing image to png", e);
            return null;
        }
        Element i = (Element)super.cloneNode(doc, eold);
        i.setAttributeNS("http://www.w3.org/1999/xlink", "href", os.toString().replaceAll("\\s*[\\r\\n]+\\s*", ""));
        return i;
    }

    protected Node inlineExternal(Document doc, ParsedURL urldata, Node eold) {
        File in = new File(urldata.getPath());
        if (!in.exists()) {
            LoggingUtil.warning("Referencing non-existant file: " + urldata.toString());
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int read;
            os.write("data:image/png;base64,".getBytes());
            Base64EncoderStream encoder = new Base64EncoderStream(os);
            FileInputStream instream = new FileInputStream(in);
            byte[] buf = new byte[4096];
            while ((read = instream.read(buf, 0, buf.length)) > 0) {
                encoder.write(buf, 0, read);
            }
            instream.close();
            encoder.close();
        }
        catch (IOException e) {
            LoggingUtil.exception("Exception serializing image to png", e);
            return null;
        }
        Element i = (Element)super.cloneNode(doc, eold);
        i.setAttributeNS("http://www.w3.org/1999/xlink", "href", os.toString().replaceAll("\\s*[\\r\\n]+\\s*", ""));
        return i;
    }
}

