/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class DragableArea
implements EventListener {
    protected final Element element;
    protected final Element coordref;
    protected final SVGPlot svgp;
    protected SVGPoint startDragPoint = null;
    protected DragListener listener = null;

    public DragableArea(SVGPlot plot, double x, double y, double w, double h) {
        this.svgp = plot;
        this.element = plot.svgRect(x, y, w, h);
        this.makeInvisible();
        this.coordref = this.element;
        this.enableStart();
    }

    public DragableArea(SVGPlot plot, Element coordref, double x, double y, double w, double h) {
        this.svgp = plot;
        this.element = plot.svgRect(x, y, w, h);
        this.makeInvisible();
        this.coordref = coordref;
        this.enableStart();
    }

    public DragableArea(SVGPlot plot, double x, double y, double w, double h, DragListener listener) {
        this.svgp = plot;
        this.element = plot.svgRect(x, y, w, h);
        this.makeInvisible();
        this.coordref = this.element;
        this.listener = listener;
        this.enableStart();
    }

    public DragableArea(SVGPlot plot, Element coordref, double x, double y, double w, double h, DragListener listener) {
        this.svgp = plot;
        this.element = plot.svgRect(x, y, w, h);
        this.makeInvisible();
        this.coordref = coordref;
        this.listener = listener;
        this.enableStart();
    }

    public void destroy() {
        this.disableStart();
        this.disableStop();
    }

    public Element getElement() {
        return this.element;
    }

    public void enableStart() {
        EventTarget targ = (EventTarget)((Object)this.element);
        targ.addEventListener("mousedown", this, false);
    }

    public void disableStart() {
        EventTarget targ = (EventTarget)((Object)this.element);
        targ.removeEventListener("mousedown", this, false);
    }

    protected void enableStop() {
        SVGSVGElement targ = this.svgp.getDocument().getRootElement();
        targ.addEventListener("mousemove", this, false);
        targ.addEventListener("mouseup", this, false);
        targ.addEventListener("mouseout", this, false);
    }

    protected void disableStop() {
        SVGSVGElement targ = this.svgp.getDocument().getRootElement();
        targ.removeEventListener("mousemove", this, false);
        targ.removeEventListener("mouseup", this, false);
        targ.removeEventListener("mouseout", this, false);
    }

    @Override
    public void handleEvent(Event evt) {
        if (evt.getType().equals("mousedown")) {
            SVGPoint dragPoint = this.getCoordinates(evt);
            if (this.startDrag(dragPoint, evt)) {
                this.startDragPoint = dragPoint;
                this.enableStop();
            }
        } else if (evt.getType().equals("mousemove")) {
            SVGPoint dragPoint;
            if (this.startDragPoint != null && !this.duringDrag(this.startDragPoint, dragPoint = this.getCoordinates(evt), evt, evt.getTarget() == this.element)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else if (evt.getType().equals("mouseup")) {
            SVGPoint dragPoint;
            if (this.startDragPoint != null && this.endDrag(this.startDragPoint, dragPoint = this.getCoordinates(evt), evt, evt.getTarget() == this.element)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else if (evt.getType().equals("mouseout")) {
            SVGPoint dragPoint;
            if (this.startDragPoint != null && evt.getTarget() == evt.getCurrentTarget() && this.endDrag(this.startDragPoint, dragPoint = this.getCoordinates(evt), evt, false)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else {
            LoggingUtil.warning("Unrecognized event: " + evt);
        }
    }

    protected SVGPoint getCoordinates(Event evt) {
        return SVGUtil.elementCoordinatesFromEvent(this.svgp.getDocument(), this.coordref, evt);
    }

    protected boolean startDrag(SVGPoint startPoint, Event evt) {
        if (this.listener != null) {
            return this.listener.startDrag(startPoint, evt);
        }
        return true;
    }

    protected boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
        if (this.listener != null) {
            return this.listener.duringDrag(startPoint, dragPoint, evt, inside);
        }
        return true;
    }

    protected boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
        if (this.listener != null) {
            return this.listener.endDrag(startPoint, dragPoint, evt, inside);
        }
        return true;
    }

    public void makeInvisible() {
        CSSClass cls = new CSSClass(this, "unused");
        cls.setStatement("fill-opacity", "0");
        cls.setStatement("cursor", "pointer");
        SVGUtil.setAtt(this.element, "style", cls.inlineCSS());
    }

    public void makeVisible() {
        CSSClass cls = new CSSClass(this, "unused");
        cls.setStatement("fill", "green");
        cls.setStatement("fill-opacity", "0.2");
        cls.setStatement("cursor", "pointer");
        SVGUtil.setAtt(this.element, "style", cls.inlineCSS());
    }

    public static interface DragListener {
        public boolean startDrag(SVGPoint var1, Event var2);

        public boolean duringDrag(SVGPoint var1, SVGPoint var2, Event var3, boolean var4);

        public boolean endDrag(SVGPoint var1, SVGPoint var2, Event var3, boolean var4);
    }
}

