/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGUpdateSynchronizer;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;

public class JSVGSynchronizedCanvas
extends JSVGCanvas {
    private static final long serialVersionUID = 1L;
    private final JSVGUpdateSynchronizer synchronizer;
    private SVGPlot plot = null;
    private final AtomicReference<Runnable> latest = new AtomicReference();

    public JSVGSynchronizedCanvas() {
        this.synchronizer = new JSVGUpdateSynchronizer(this);
        super.setDocumentState(1);
    }

    public SVGPlot getPlot() {
        return this.plot;
    }

    @Override
    @Deprecated
    public synchronized void setDocument(Document doc) {
        super.setDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlot(SVGPlot newplot) {
        JSVGUpdateSynchronizer jSVGUpdateSynchronizer = this.synchronizer;
        synchronized (jSVGUpdateSynchronizer) {
            super.setSVGDocument(null);
            this.scheduleSetPlot(this.plot, newplot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSetPlot(final SVGPlot oldplot, final SVGPlot newplot) {
        UpdateManager um = this.getUpdateManager();
        if (um != null) {
            UpdateManager updateManager = um;
            synchronized (updateManager) {
                if (um.isRunning()) {
                    Runnable detach = new Runnable(){

                        @Override
                        public void run() {
                            if (JSVGSynchronizedCanvas.this.latest.compareAndSet(this, null)) {
                                JSVGSynchronizedCanvas.this.detachPlot(oldplot);
                                JSVGSynchronizedCanvas.this.attachPlot(newplot);
                            }
                        }
                    };
                    this.latest.set(detach);
                    um.getUpdateRunnableQueue().preemptLater(detach);
                    return;
                }
            }
        } else if (oldplot != null) {
            LoggingUtil.warning("No update manager, but a previous plot exists. Incorrectly initialized?");
        }
        this.detachPlot(oldplot);
        this.attachPlot(newplot);
    }

    private void attachPlot(SVGPlot newplot) {
        this.plot = newplot;
        if (newplot == null) {
            super.setSVGDocument(null);
            return;
        }
        newplot.synchronizeWith(this.synchronizer);
        super.setSVGDocument(newplot.getDocument());
        super.setDisableInteractions(newplot.getDisableInteractions());
    }

    private void detachPlot(SVGPlot oldplot) {
        if (oldplot == null) {
            return;
        }
        this.plot = null;
        oldplot.unsynchronizeWith(this.synchronizer);
    }
}

