/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.visualization.svg.UpdateRunner;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerAdapter;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.swing.svg.JSVGComponent;

class JSVGUpdateSynchronizer
implements UpdateSynchronizer {
    private final WeakReference<JSVGComponent> cref;
    private Set<WeakReference<UpdateRunner>> updaterunner = new CopyOnWriteArraySet<WeakReference<UpdateRunner>>();
    private final UMAdapter umadapter = new UMAdapter();
    private final AtomicReference<Runnable> pending = new AtomicReference();

    protected JSVGUpdateSynchronizer(JSVGComponent component) {
        assert (component != null);
        this.cref = new WeakReference<JSVGComponent>(component);
        component.addUpdateManagerListener(this.umadapter);
    }

    @Override
    public void activate() {
        this.makeRunnerIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeRunnerIfNeeded() {
        boolean stop = true;
        for (WeakReference<UpdateRunner> wur : this.updaterunner) {
            UpdateRunner ur = (UpdateRunner)wur.get();
            if (ur == null) {
                this.updaterunner.remove(wur);
                continue;
            }
            if (ur.isEmpty()) continue;
            stop = false;
        }
        if (stop) {
            return;
        }
        if (this.pending.get() != null) {
            return;
        }
        JSVGComponent component = (JSVGComponent)this.cref.get();
        if (component == null) {
            return;
        }
        JSVGUpdateSynchronizer jSVGUpdateSynchronizer = this;
        synchronized (jSVGUpdateSynchronizer) {
            JSVGComponent jSVGComponent = component;
            synchronized (jSVGComponent) {
                UpdateManager um = component.getUpdateManager();
                if (um != null) {
                    UpdateManager updateManager = um;
                    synchronized (updateManager) {
                        if (um.isRunning()) {
                            Runnable newrunner = new Runnable(){

                                @Override
                                public void run() {
                                    if (JSVGUpdateSynchronizer.this.pending.compareAndSet(this, null)) {
                                        for (WeakReference wur : JSVGUpdateSynchronizer.this.updaterunner) {
                                            UpdateRunner ur = (UpdateRunner)wur.get();
                                            if (ur == null || ur.isEmpty()) continue;
                                            ur.runQueue();
                                        }
                                    }
                                }
                            };
                            this.pending.set(newrunner);
                            um.getUpdateRunnableQueue().invokeLater(newrunner);
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addUpdateRunner(UpdateRunner updateRunner) {
        for (WeakReference<UpdateRunner> wur : this.updaterunner) {
            if (wur.get() != null) continue;
            this.updaterunner.remove(wur);
        }
        this.updaterunner.add(new WeakReference<UpdateRunner>(updateRunner));
    }

    private class UMAdapter
    extends UpdateManagerAdapter {
        protected UMAdapter() {
        }

        @Override
        public void managerStarted(UpdateManagerEvent e) {
            JSVGUpdateSynchronizer.this.makeRunnerIfNeeded();
        }

        @Override
        public void managerStopped(UpdateManagerEvent e) {
            JSVGUpdateSynchronizer.this.pending.set(null);
        }
    }
}

