/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public abstract class LazyCanvasResizer
extends ComponentAdapter {
    public static final double DEFAULT_THRESHOLD = 0.05;
    double threshold;
    double activeRatio;
    Component component;

    public LazyCanvasResizer(Component component, double threshold) {
        this.threshold = threshold;
        this.component = component;
        this.activeRatio = this.getCurrentRatio();
    }

    public LazyCanvasResizer(Component component) {
        this(component, 0.05);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        double newRatio;
        if (e.getComponent() == this.component && Math.abs((newRatio = this.getCurrentRatio()) - this.activeRatio) > this.threshold) {
            this.activeRatio = newRatio;
            this.executeResize(newRatio);
        }
    }

    public final double getCurrentRatio() {
        return (double)this.component.getWidth() / (double)this.component.getHeight();
    }

    public abstract void executeResize(double var1);

    public double getActiveRatio() {
        return this.activeRatio;
    }
}

