/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLProtocolHandler;

public class ThumbnailRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry,
ParsedURLProtocolHandler {
    public static final String INTERNAL_PROTOCOL = "thumb";
    public static final String INTERNAL_PREFIX = "thumb:";
    public static final String INTERNAL_MIME_TYPE = "internal/thumb";
    public static final float PRIORITY = 1000.0f;
    private static final Logging LOG = Logging.getLogger(ThumbnailRegistryEntry.class);
    private static final Int2ObjectOpenHashMap<SoftReference<RenderedImage>> images = new Int2ObjectOpenHashMap();
    private static int counter = 1;

    public ThumbnailRegistryEntry() {
        super("Internal", 1000.0f, new String[0], new String[]{INTERNAL_MIME_TYPE});
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Registry initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerImage(RenderedImage img) {
        Int2ObjectOpenHashMap<SoftReference<RenderedImage>> int2ObjectOpenHashMap = images;
        synchronized (int2ObjectOpenHashMap) {
            int key = counter++;
            assert (images.get(key) == null);
            images.put(key, new SoftReference<RenderedImage>(img));
            if (counter % 50 == 49) {
                Iterator iter = images.values().iterator();
                while (iter.hasNext()) {
                    SoftReference ref = (SoftReference)iter.next();
                    if (ref != null && ref.get() != null) continue;
                    iter.remove();
                }
            }
            if (LOG.isDebuggingFiner()) {
                LOG.debugFiner("Registered image: " + key);
            }
            return key;
        }
    }

    @Override
    public boolean isCompatibleURL(ParsedURL url) {
        return ThumbnailRegistryEntry.isCompatibleURLStatic(url);
    }

    public static boolean isCompatibleURLStatic(ParsedURL url) {
        return url.getProtocol().equals(INTERNAL_PROTOCOL);
    }

    @Override
    public Filter handleURL(ParsedURL url, boolean needRawData) {
        Filter ret = ThumbnailRegistryEntry.handleURL(url);
        if (ret != null) {
            return ret;
        }
        return ImageTagRegistry.getBrokenLinkImage(this, "imageDir does not exist", new Object[0]);
    }

    public static Filter handleURL(ParsedURL url) {
        int id;
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("handleURL " + url.toString());
        }
        if (!ThumbnailRegistryEntry.isCompatibleURLStatic(url)) {
            return null;
        }
        try {
            id = ParseUtil.parseIntBase10(url.getPath());
        }
        catch (NumberFormatException e) {
            return null;
        }
        SoftReference<RenderedImage> ref = images.get(id);
        if (ref != null) {
            RenderedImage ri = ref.get();
            if (ri == null) {
                LOG.warning("Referenced image has expired from the cache!");
            } else {
                return new RedRable(GraphicsUtil.wrap(ri));
            }
        }
        return null;
    }

    @Override
    public ParsedURLData parseURL(String urlStr) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("parseURL: " + urlStr);
        }
        if (urlStr.startsWith(INTERNAL_PREFIX)) {
            InternalParsedURLData ret = new InternalParsedURLData(urlStr.substring(INTERNAL_PREFIX.length()));
            return ret;
        }
        return null;
    }

    @Override
    public ParsedURLData parseURL(ParsedURL basepurl, String urlStr) {
        return this.parseURL(urlStr);
    }

    @Override
    public String getProtocolHandled() {
        return INTERNAL_PROTOCOL;
    }

    private static class InternalParsedURLData
    extends ParsedURLData {
        public InternalParsedURLData(String id) {
            this.protocol = ThumbnailRegistryEntry.INTERNAL_PROTOCOL;
            this.contentType = ThumbnailRegistryEntry.INTERNAL_MIME_TYPE;
            this.path = id;
        }

        @Override
        public String getContentType(String userAgent) {
            return ThumbnailRegistryEntry.INTERNAL_MIME_TYPE;
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public InputStream openStream(String userAgent, Iterator mimeTypes) throws IOException {
            return null;
        }
    }
}

