/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.css;

import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CSSClass {
    private String name;
    private Collection<Pair<String, String>> statements;
    private WeakReference<Object> owner;

    public CSSClass(Object owner, String name, Collection<Pair<String, String>> statements) {
        this.owner = new WeakReference<Object>(owner);
        this.name = name;
        this.statements = statements;
        if (!CSSClass.checkName(name)) {
            throw new InvalidCSS("Given name is not a valid CSS class name.");
        }
        if (this.statements != null) {
            if (!CSSClass.checkCSSStatements(this.statements)) {
                throw new InvalidCSS("Invalid statement in CSS class " + name);
            }
        } else {
            this.statements = new ArrayList<Pair<String, String>>();
        }
    }

    public CSSClass(Object owner, String name) {
        this(owner, name, (Collection<Pair<String, String>>)null);
    }

    public CSSClass(Object owner, String name, CSSClass other) {
        this(owner, name, new ArrayList<Pair<String, String>>(other.statements));
    }

    public static boolean checkName(String name) {
        return name != null;
    }

    public static String sanitizeName(String name) {
        return name;
    }

    public static boolean checkCSSStatement(String key, String value) {
        return key != null && value != null;
    }

    public static boolean checkCSSStatements(Collection<Pair<String, String>> statements) {
        for (Pair<String, String> pair : statements) {
            if (CSSClass.checkCSSStatement(pair.getFirst(), pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getOwner() {
        return this.owner.get();
    }

    public String getStatement(String key) {
        for (Pair<String, String> pair : this.statements) {
            if (!pair.getFirst().equals(key)) continue;
            return pair.getSecond();
        }
        return null;
    }

    public Collection<Pair<String, String>> getStatements() {
        return Collections.unmodifiableCollection(this.statements);
    }

    public void setStatement(String key, String value) {
        if (value != null && !CSSClass.checkCSSStatement(key, value)) {
            throw new InvalidCSS("Invalid CSS statement.");
        }
        for (Pair<String, String> pair : this.statements) {
            if (!pair.getFirst().equals(key)) continue;
            if (value != null) {
                pair.setSecond(value);
            } else {
                this.statements.remove(pair);
            }
            return;
        }
        if (value != null) {
            this.statements.add(new Pair<String, String>(key, value));
        }
    }

    public void setStatement(String key, int value) {
        this.setStatement(key, Integer.toString(value));
    }

    public void setStatement(String key, double value) {
        this.setStatement(key, Double.toString(value));
    }

    public void removeStatement(String key) {
        this.setStatement(key, null);
    }

    public void appendCSSDefinition(StringBuilder buf) {
        buf.append("\n.");
        buf.append(this.name);
        buf.append('{');
        for (Pair<String, String> pair : this.statements) {
            buf.append(pair.getFirst());
            buf.append(':');
            buf.append(pair.getSecond());
            buf.append(";\n");
        }
        buf.append("}\n");
    }

    public String inlineCSS() {
        StringBuilder buf = new StringBuilder();
        for (Pair<String, String> pair : this.statements) {
            buf.append(pair.getFirst());
            buf.append(':');
            buf.append(pair.getSecond());
            buf.append(';');
        }
        return buf.toString();
    }

    public static class InvalidCSS
    extends RuntimeException {
        private static final long serialVersionUID = 3130536799704124363L;

        public InvalidCSS(String msg) {
            super(msg);
        }
    }
}

