/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.css;

import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CSSClassManager {
    private HashMap<String, CSSClass> store = new HashMap();

    public CSSClass addClass(CSSClass clss) throws CSSNamingConflict {
        CSSClass existing = this.store.get(clss.getName());
        if (existing != null && existing.getOwner() != null && existing.getOwner() != clss.getOwner()) {
            throw new CSSNamingConflict("CSS class naming conflict between " + clss.getOwner().toString() + " and " + existing.getOwner().toString());
        }
        return this.store.put(clss.getName(), clss);
    }

    public synchronized void removeClass(CSSClass clss) {
        CSSClass existing = this.store.get(clss.getName());
        if (existing == clss) {
            this.store.remove(existing.getName());
        }
    }

    public CSSClass getClass(String name, Object owner) throws CSSNamingConflict {
        CSSClass existing = this.store.get(name);
        if (existing == null) {
            return null;
        }
        if (owner != null && existing.getOwner() != owner) {
            throw new CSSNamingConflict("CSS class naming conflict between " + owner.toString() + " and " + existing.getOwner().toString());
        }
        return existing;
    }

    public CSSClass getClass(String name) {
        return this.store.get(name);
    }

    public boolean contains(String name) {
        return this.store.containsKey(name);
    }

    public void serialize(StringBuilder buf) {
        for (CSSClass clss : this.store.values()) {
            clss.appendCSSDefinition(buf);
        }
    }

    public Collection<CSSClass> getClasses() {
        return this.store.values();
    }

    public boolean testMergeable(CSSClassManager other) {
        for (CSSClass clss : other.getClasses()) {
            CSSClass existing = this.store.get(clss.getName());
            if (existing == null || existing.getOwner() == null || clss.getOwner() == null || existing.getOwner() == clss.getOwner()) continue;
            return false;
        }
        return true;
    }

    public boolean mergeCSSFrom(CSSClassManager other) throws CSSNamingConflict {
        for (CSSClass clss : other.getClasses()) {
            this.addClass(clss);
        }
        return true;
    }

    public void updateStyleElement(Document document, Element style) {
        StringBuilder buf = new StringBuilder();
        this.serialize(buf);
        Text cont = document.createTextNode(buf.toString());
        while (style.hasChildNodes()) {
            style.removeChild(style.getFirstChild());
        }
        style.appendChild(cont);
    }

    public Element makeStyleElement(Document document) {
        Element style = SVGUtil.makeStyleElement(document);
        this.updateStyleElement(document, style);
        return style;
    }

    public static class CSSNamingConflict
    extends Exception {
        private static final long serialVersionUID = 4163822727195636747L;

        public CSSNamingConflict(String msg) {
            super(msg);
        }
    }
}

