/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.ResultWriter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuToggle;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGSynchronizedCanvas;
import de.lmu.ifi.dbs.elki.visualization.batikutil.LazyCanvasResizer;
import de.lmu.ifi.dbs.elki.visualization.gui.SelectionTableWindow;
import de.lmu.ifi.dbs.elki.visualization.gui.detail.DetailView;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.DetailViewSelectedEvent;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.OverviewPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;

public class ResultWindow
extends JFrame
implements ResultListener,
VisualizationListener {
    private static final long serialVersionUID = 1L;
    private DynamicMenu menubar;
    private JSVGSynchronizedCanvas svgCanvas;
    private OverviewPlot overview;
    protected VisualizerContext context;
    private DetailView currentSubplot = null;
    private boolean single = false;

    public ResultWindow(String title, VisualizerContext context, boolean single) {
        super(title);
        this.context = context;
        this.single = single;
        this.setDefaultCloseOperation(2);
        try {
            this.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel panel = new JPanel(new BorderLayout());
        this.menubar = new DynamicMenu();
        panel.add("North", this.menubar.getMenuBar());
        this.svgCanvas = new JSVGSynchronizedCanvas();
        panel.add("Center", this.svgCanvas);
        this.getContentPane().add(panel);
        this.overview = new OverviewPlot(context, single);
        this.overview.addActionListener(e -> {
            if (e instanceof DetailViewSelectedEvent) {
                this.showSubplot((DetailViewSelectedEvent)e);
            }
            if ("Overview refreshing" == e.getActionCommand() && this.currentSubplot == null) {
                this.showPlot(null);
            }
            if ("Overview refreshed" == e.getActionCommand() && this.currentSubplot == null) {
                this.showOverview();
            }
        });
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.overview.screenwidth = dim.width;
        this.overview.screenheight = dim.height;
        this.setSize(dim.width - 50, dim.height - 50);
        this.setExtendedState(6);
        LazyCanvasResizer listener = new LazyCanvasResizer(this, 0.1){

            @Override
            public void executeResize(double newratio) {
                ResultWindow.this.handleResize(newratio);
            }
        };
        this.addComponentListener(listener);
        this.svgCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            @Override
            public void gvtBuildCompleted(GVTTreeBuilderEvent arg0) {
                ResultWindow.this.menubar.updateVisualizerMenus();
            }
        });
        KeyStroke ctrle = KeyStroke.getKeyStroke(69, 128);
        KeyStroke ctrls = KeyStroke.getKeyStroke(83, 128);
        KeyStroke ctrlq = KeyStroke.getKeyStroke(81, 128);
        KeyStroke ctrlw = KeyStroke.getKeyStroke(87, 128);
        KeyStroke ctrlo = KeyStroke.getKeyStroke(79, 128);
        panel.registerKeyboardAction(e -> this.saveCurrentPlot(), ctrle, 2);
        panel.registerKeyboardAction(e -> this.saveCurrentPlot(), ctrls, 2);
        panel.registerKeyboardAction(e -> this.close(), ctrlq, 2);
        panel.registerKeyboardAction(e -> this.close(), ctrlw, 2);
        panel.registerKeyboardAction(e -> this.showOverview(), ctrlo, 2);
        context.addResultListener(this);
        context.addVisualizationListener(this);
        this.overview.initialize(listener.getCurrentRatio());
    }

    @Override
    public void dispose() {
        this.context.removeResultListener(this);
        this.context.removeVisualizationListener(this);
        this.svgCanvas.setPlot(null);
        this.overview.destroy();
        if (this.currentSubplot != null) {
            this.currentSubplot.dispose();
            this.currentSubplot = null;
        }
        super.dispose();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void showOverview() {
        if (this.currentSubplot != null) {
            this.currentSubplot.destroy();
        }
        this.currentSubplot = null;
        this.showPlot(this.overview.getPlot());
    }

    protected void showSubplot(DetailViewSelectedEvent e) {
        if (!this.single) {
            this.currentSubplot = e.makeDetailView();
            this.showPlot(this.currentSubplot);
        }
    }

    private void showPlot(SVGPlot plot) {
        if (this.svgCanvas.getPlot() instanceof DetailView) {
            ((DetailView)this.svgCanvas.getPlot()).destroy();
        }
        this.svgCanvas.setPlot(plot);
        this.menubar.enableOverview(plot != this.overview.getPlot());
        this.menubar.enableExport(plot != null);
        this.updateVisualizerMenus();
    }

    protected void saveCurrentPlot() {
        SVGPlot currentPlot = this.svgCanvas.getPlot();
        if (currentPlot != null) {
            SVGSaveDialog.showSaveDialog(currentPlot, 512, 512);
        }
    }

    protected void invokeTextWriter() {
        JOptionPane.showMessageDialog(this, "This function is a minimal call to TextWriter with default options.\nYou currently cannot select what data is written, or how.\nSome results cannot be written to text files at all.\nThere will not be a 'success' or 'failure' message in the UI.\nFor full control, please use the Java API.", "Notice", 2);
        JFileChooser fc = new JFileChooser(new File("."));
        fc.setDialogTitle("Choose Folder to Write to");
        fc.setFileSelectionMode(1);
        TextWriterPanel optionsPanel = new TextWriterPanel();
        fc.setAccessory(optionsPanel);
        int ret = fc.showSaveDialog(null);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            boolean gzip = optionsPanel.compress.isSelected();
            String filtertext = optionsPanel.filterField.getText();
            try {
                Pattern filter = filtertext.isEmpty() ? null : Pattern.compile(filtertext);
                new ResultWriter(file, gzip, false, filter).processNewResult(this.context.getHierarchy(), this.context.getBaseResult());
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(this, "Filter pattern was not a valid regular expression.", "Pattern error", 0);
            }
        }
    }

    protected void showTableView() {
        new SelectionTableWindow(this.context).setVisible(true);
    }

    protected void update() {
        this.updateVisualizerMenus();
        if (this.currentSubplot != null) {
            this.showPlot(this.currentSubplot);
        }
        this.overview.lazyRefresh();
    }

    protected void handleResize(double newratio) {
        if (this.currentSubplot == null) {
            this.overview.setRatio(newratio);
        }
    }

    @Override
    public void resultAdded(Result child, Result parent) {
        this.updateVisualizerMenus();
    }

    @Override
    public void resultChanged(Result current) {
        this.updateVisualizerMenus();
    }

    @Override
    public void resultRemoved(Result child, Result parent) {
        this.updateVisualizerMenus();
    }

    @Override
    public void visualizationChanged(VisualizationItem item) {
        this.updateVisualizerMenus();
    }

    private void updateVisualizerMenus() {
        SwingUtilities.invokeLater(() -> this.menubar.updateVisualizerMenus());
    }

    private class TextWriterPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JCheckBox compress;
        JTextField filterField;

        public TextWriterPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.anchor = 17;
            c.ipadx = 2;
            this.compress = new JCheckBox("Compress output (gzip)");
            this.add((Component)this.compress, c);
            this.compress.setSelected(true);
            this.add((Component)new JLabel("Result filter:"), c);
            c.fill = 2;
            this.filterField = new JTextField();
            this.add((Component)this.filterField, c);
        }
    }

    public class DynamicMenu {
        private JMenuBar menubar = new JMenuBar();
        private JMenu filemenu = new JMenu("File");
        private JMenuItem overviewItem;
        private JMenuItem quitItem;
        private JMenuItem exportItem;
        private JMenuItem writeItem;
        private JMenu visualizersMenu;
        protected boolean simplify = true;

        public DynamicMenu() {
            this.filemenu.setMnemonic(70);
            if (!ResultWindow.this.single) {
                this.overviewItem = new JMenuItem("Open Overview");
                this.overviewItem.setMnemonic(79);
                this.overviewItem.setEnabled(false);
                this.overviewItem.addActionListener(e -> ResultWindow.this.showOverview());
                this.filemenu.add(this.overviewItem);
            }
            this.exportItem = new JMenuItem("Export Plot");
            this.exportItem.setMnemonic(69);
            this.exportItem.setEnabled(false);
            this.exportItem.addActionListener(e -> ResultWindow.this.saveCurrentPlot());
            this.filemenu.add(this.exportItem);
            this.writeItem = new JMenuItem("Write Data to Folder");
            this.writeItem.setMnemonic(87);
            this.writeItem.addActionListener(e -> ResultWindow.this.invokeTextWriter());
            this.filemenu.add(this.writeItem);
            this.quitItem = new JMenuItem("Quit");
            this.quitItem.setMnemonic(81);
            this.quitItem.addActionListener(e -> ResultWindow.this.close());
            this.filemenu.add(this.quitItem);
            this.menubar.add(this.filemenu);
            this.visualizersMenu = new JMenu("Visualizers");
            this.visualizersMenu.setMnemonic(86);
            this.menubar.add(this.visualizersMenu);
        }

        protected synchronized void updateVisualizerMenus() {
            It<Object> iter;
            Projection proj = null;
            if (ResultWindow.this.svgCanvas.getPlot() instanceof DetailView) {
                PlotItem item = ((DetailView)ResultWindow.this.svgCanvas.getPlot()).getPlotItem();
                proj = item.proj;
            }
            this.menubar.removeAll();
            this.menubar.add(this.filemenu);
            ResultHierarchy hier = ResultWindow.this.context.getHierarchy();
            VisualizationTree vistree = ResultWindow.this.context.getVisHierarchy();
            Result start = ResultWindow.this.context.getBaseResult();
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            if (start == null) {
                iter = hier.iterAll();
                while (iter.valid()) {
                    if (hier.numParents(iter.get()) == 0) {
                        this.recursiveBuildMenu(items, iter.get(), hier, vistree, proj);
                    }
                    iter.advance();
                }
            } else {
                iter = hier.iterChildren(start);
                while (iter.valid()) {
                    this.recursiveBuildMenu(items, iter.get(), hier, vistree, proj);
                    iter.advance();
                }
            }
            for (JMenuItem item : items) {
                this.menubar.add(item);
            }
            this.menubar.revalidate();
            this.menubar.repaint();
        }

        private void recursiveBuildMenu(Collection<JMenuItem> items, Object r, ResultHierarchy hier, Hierarchy<Object> vistree, Projection proj) {
            JMenuItem a;
            It<Object> iter;
            String nam;
            if (r instanceof Result) {
                nam = ((Result)r).getLongName();
            } else if (r instanceof VisualizationItem) {
                nam = ((VisualizationItem)r).getMenuName();
            } else {
                return;
            }
            ArrayList<JMenuItem> subitems = new ArrayList<JMenuItem>();
            if (r instanceof Result) {
                iter = hier.iterChildren((Result)r);
                while (iter.valid()) {
                    this.recursiveBuildMenu(subitems, iter.get(), hier, vistree, proj);
                    iter.advance();
                }
            }
            iter = vistree.iterChildren(r);
            while (iter.valid()) {
                this.recursiveBuildMenu(subitems, iter.get(), hier, vistree, proj);
                iter.advance();
            }
            JMenuItem item = null;
            if (proj == null) {
                item = this.makeMenuItemForVisualizer(r);
            } else {
                It<Projector> iter2 = vistree.iterAncestorsSelf(r).filter(Projector.class);
                while (iter2.valid()) {
                    if (iter2.get() == proj.getProjector()) {
                        item = this.makeMenuItemForVisualizer(r);
                        break;
                    }
                    iter2.advance();
                }
            }
            int numchild = subitems.size();
            if (numchild == 0) {
                if (item != null) {
                    items.add(item);
                }
                return;
            }
            if (this.simplify && numchild == 1 && (a = subitems.get(0)) instanceof JMenu) {
                if (nam != null) {
                    a.setText(nam + " " + a.getText());
                }
                items.add(a);
                return;
            }
            JMenu submenu = new JMenu(nam != null ? nam : "unnamed");
            if (item != null) {
                submenu.add(item);
            }
            for (JMenuItem subitem : subitems) {
                submenu.add(subitem);
            }
            items.add(submenu);
        }

        private JMenuItem makeMenuItemForVisualizer(Object r) {
            JMenuItem item;
            if (r instanceof VisualizationMenuAction) {
                VisualizationMenuAction action = (VisualizationMenuAction)r;
                JMenuItem visItem = new JMenuItem(action.getMenuName());
                visItem.setEnabled(action.enabled());
                visItem.addActionListener(e -> action.activate());
                return visItem;
            }
            if (r instanceof VisualizationMenuToggle) {
                VisualizationMenuToggle toggle = (VisualizationMenuToggle)r;
                JCheckBoxMenuItem visItem = new JCheckBoxMenuItem(toggle.getMenuName(), toggle.active());
                visItem.setEnabled(toggle.enabled());
                visItem.addItemListener(e -> toggle.toggle());
                return visItem;
            }
            if (!(r instanceof VisualizationTask)) {
                return null;
            }
            VisualizationTask v = (VisualizationTask)r;
            String name = v.getMenuName();
            boolean enabled = v.isVisible();
            boolean istool = v.isTool();
            if (!istool) {
                JCheckBoxMenuItem visItem = new JCheckBoxMenuItem(name, enabled);
                visItem.addItemListener(e -> VisualizationTree.setVisible(ResultWindow.this.context, v, visItem.getState()));
                item = visItem;
            } else {
                JRadioButtonMenuItem visItem = new JRadioButtonMenuItem(name, enabled);
                visItem.addItemListener(e -> VisualizationTree.setVisible(ResultWindow.this.context, v, visItem.isSelected()));
                item = visItem;
            }
            return item;
        }

        public JMenuBar getMenuBar() {
            return this.menubar;
        }

        public void enableOverview(boolean b) {
            if (this.overviewItem != null) {
                this.overviewItem.setEnabled(b);
            }
        }

        public void enableExport(boolean b) {
            this.exportItem.setEnabled(b);
        }

        public void enableWriter(boolean b) {
            this.writeItem.setEnabled(b);
        }
    }
}

