/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SelectionTableWindow
extends JFrame
implements DataStoreListener,
ResultListener {
    private static final String NAME = "Selected data objects";
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JButton closeButton;
    private JButton deleteButton;
    private DatabaseTableModel dotTableModel = new DatabaseTableModel();
    private static final Logging LOG = Logging.getLogger(SelectionTableWindow.class);
    ArrayModifiableDBIDs dbids;
    UpdatableDatabase database;
    ModifiableRelation<ClassLabel> crep;
    ModifiableRelation<String> orep;
    protected final VisualizerContext context;

    public SelectionTableWindow(VisualizerContext context) {
        super(NAME);
        try {
            this.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context = context;
        this.database = (UpdatableDatabase)ResultUtil.findDatabase(context.getHierarchy());
        this.crep = null;
        this.orep = null;
        this.updateFromSelection();
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new JTable(this.dotTableModel);
        JScrollPane pane = new JScrollPane(this.table);
        panel.add((Component)pane, "Center");
        JPanel buttons = new JPanel();
        panel.add((Component)buttons, "South");
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(e -> this.dispose());
        this.deleteButton = new JButton("delete");
        this.deleteButton.addActionListener(e -> this.handleDelete());
        buttons.add(this.closeButton);
        buttons.add(this.deleteButton);
        this.setSize(500, 500);
        this.add(panel);
        this.setVisible(true);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        context.addResultListener(this);
        context.addDataStoreListener(this);
    }

    @Override
    public void dispose() {
        this.context.removeDataStoreListener(this);
        this.context.removeResultListener(this);
        super.dispose();
    }

    protected void updateFromSelection() {
        DBIDSelection sel = this.context.getSelection();
        if (sel != null) {
            this.dbids = DBIDUtil.newArray(sel.getSelectedIds());
            this.dbids.sort();
        } else {
            this.dbids = DBIDUtil.newArray();
        }
    }

    protected void handleDelete() {
        HashSetModifiableDBIDs todel = DBIDUtil.newHashSet();
        HashSetModifiableDBIDs remain = DBIDUtil.newHashSet(this.dbids);
        DBIDArrayMIter it = this.dbids.iter();
        for (int row : this.table.getSelectedRows()) {
            it.seek(row);
            todel.add(it);
            remain.remove(it);
        }
        this.context.setSelection(new DBIDSelection(remain));
        DBIDMIter iter = todel.iter();
        while (iter.valid()) {
            this.database.delete(iter);
            iter.advance();
        }
    }

    @Override
    public void contentChanged(DataStoreEvent e) {
        if (e.getInserts().isEmpty() && e.getRemovals().isEmpty() && !e.getUpdates().isEmpty()) {
            this.dotTableModel.fireTableDataChanged();
        } else {
            this.dotTableModel.fireTableStructureChanged();
        }
    }

    @Override
    public void resultAdded(Result child, Result parent) {
    }

    @Override
    public void resultRemoved(Result child, Result parent) {
    }

    @Override
    public void resultChanged(Result current) {
        if (current instanceof SelectionResult || current instanceof Database) {
            this.updateFromSelection();
            this.dotTableModel.fireTableStructureChanged();
        }
    }

    class DatabaseTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        DatabaseTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectionTableWindow.this.dbids.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DBIDArrayMIter id = SelectionTableWindow.this.dbids.iter().seek(rowIndex);
            if (columnIndex == 0) {
                return DBIDUtil.toString(id);
            }
            if (columnIndex == 1) {
                return SelectionTableWindow.this.orep.get(id);
            }
            if (columnIndex == 2) {
                return SelectionTableWindow.this.crep.get(id);
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "DBID";
            }
            if (column == 1) {
                return "Object label";
            }
            if (column == 2) {
                return "Class label";
            }
            return "Dim " + (column - 3 + 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                LOG.warning("Tried to edit DBID, this is not allowed.");
                return;
            }
            DBIDArrayMIter id = SelectionTableWindow.this.dbids.iter().seek(rowIndex);
            if (columnIndex == 1 && aValue instanceof String) {
                SelectionTableWindow.this.orep.insert(id, (String)aValue);
            }
            if (columnIndex == 2 && aValue instanceof String) {
                SimpleClassLabel lbl = new SimpleClassLabel((String)aValue);
                SelectionTableWindow.this.crep.insert(id, lbl);
            }
            if (!(aValue instanceof String)) {
                LOG.warning("Was expecting a String value from the input element, got: " + aValue.getClass());
                return;
            }
            throw new AbortException("FIXME: INCOMPLETE TRANSITION");
        }
    }
}

