/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGSynchronizedCanvas;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class SimpleSVGViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JSVGSynchronizedCanvas svgCanvas;

    public SimpleSVGViewer() throws HeadlessException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(2);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dim.width - 50, dim.height - 50);
        JMenuItem exportItem = new JMenuItem("Export");
        exportItem.setMnemonic(69);
        exportItem.addActionListener(e -> this.saveCurrentPlot());
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.setMnemonic(81);
        quitItem.addActionListener(e -> this.close());
        JPanel panel = new JPanel(new BorderLayout());
        KeyStroke ctrle = KeyStroke.getKeyStroke(69, 128);
        KeyStroke ctrls = KeyStroke.getKeyStroke(83, 128);
        KeyStroke ctrlq = KeyStroke.getKeyStroke(81, 128);
        KeyStroke ctrlw = KeyStroke.getKeyStroke(87, 128);
        panel.registerKeyboardAction(e -> this.saveCurrentPlot(), ctrle, 2);
        panel.registerKeyboardAction(e -> this.saveCurrentPlot(), ctrls, 2);
        panel.registerKeyboardAction(e -> this.close(), ctrlq, 2);
        panel.registerKeyboardAction(e -> this.close(), ctrlw, 2);
        JMenuBar menubar = new JMenuBar();
        menubar.add(exportItem);
        menubar.add(quitItem);
        panel.add("North", menubar);
        this.svgCanvas = new JSVGSynchronizedCanvas();
        panel.add("Center", this.svgCanvas);
        this.getContentPane().add(panel);
        this.setExtendedState(6);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void saveCurrentPlot() {
        SVGPlot currentPlot = this.svgCanvas.getPlot();
        if (currentPlot != null) {
            SVGSaveDialog.showSaveDialog(currentPlot, 512, 512);
        } else {
            LoggingUtil.warning("saveCurrentPlot() called without a visible plot!");
        }
    }

    public void setPlot(SVGPlot plot) {
        this.svgCanvas.setPlot(plot);
    }
}

