/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.concurrent.ConcurrentLinkedDeque;

public class VisualizationPlot
extends SVGPlot {
    protected Runnable pendingRedraw = null;
    protected ConcurrentLinkedDeque<Visualization> updateQueue = new ConcurrentLinkedDeque();

    protected final void synchronizedRedraw() {
        Runnable pr;
        this.pendingRedraw = pr = new Runnable(){

            @Override
            public void run() {
                if (VisualizationPlot.this.pendingRedraw == this) {
                    VisualizationPlot.this.pendingRedraw = null;
                    VisualizationPlot.this.redraw();
                }
            }
        };
        this.scheduleUpdate(pr);
    }

    protected void redraw() {
        while (!this.updateQueue.isEmpty()) {
            Visualization vis = this.updateQueue.pop();
            vis.incrementalRedraw();
        }
    }

    public void requestRedraw(VisualizationTask task, Visualization vis) {
        this.updateQueue.add(vis);
        this.synchronizedRedraw();
    }
}

