/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.detail;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetailView
extends VisualizationPlot
implements ResultListener,
VisualizationListener {
    private static final Logging LOG = Logging.getLogger(DetailView.class);
    private PlotItem item;
    double ratio = 1.0;
    VisualizerContext context;
    Map<VisualizationTask, Visualization> taskmap = new HashMap<VisualizationTask, Visualization>();
    private double width;
    private double height;
    AtomicReference<Runnable> pendingRefresh = new AtomicReference<Object>(null);

    public DetailView(VisualizerContext context, PlotItem vis, double ratio) {
        this.context = context;
        this.item = new PlotItem(vis);
        this.ratio = ratio;
        this.item.sort();
        this.setDisableInteractions(true);
        this.addBackground(context);
        SVGEffects.addShadowFilter(this);
        SVGEffects.addLightGradient(this);
        this.initialize();
        context.addVisualizationListener(this);
        context.addResultListener(this);
    }

    private void addBackground(VisualizerContext context) {
        CSSClass cls = new CSSClass(this, "background");
        cls.setStatement("fill", context.getStyleLibrary().getBackgroundColor("page"));
        this.addCSSClassOrLogError(cls);
        Element bg = this.svgElement("rect", cls.getName());
        SVGUtil.setAtt(bg, "x", "0");
        SVGUtil.setAtt(bg, "y", "0");
        SVGUtil.setAtt(bg, "width", "100%");
        SVGUtil.setAtt(bg, "height", "100%");
        SVGUtil.setAtt(bg, "noexport", "noexport");
        this.getRoot().appendChild(bg);
    }

    private void initialize() {
        this.width = Math.sqrt(this.getRatio());
        this.height = 1.0 / this.width;
        for (VisualizationTask task : this.item.tasks) {
            Visualization v;
            if (!task.isVisible() || (v = this.instantiateVisualization(task)) == null) continue;
            this.taskmap.put(task, v);
        }
        double ratio = this.width / this.height;
        this.getRoot().setAttribute("width", "20cm");
        this.getRoot().setAttribute("height", 20.0 / ratio + "cm");
        this.getRoot().setAttribute("viewBox", "0 0 " + this.width + " " + this.height);
        this.refresh();
    }

    private synchronized void refresh() {
        this.pendingRefresh.set(null);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Refresh in thread " + Thread.currentThread().getName());
        }
        boolean updateStyle = false;
        Iterator it = this.taskmap.entrySet().stream().sorted((a, b) -> Integer.compare(((VisualizationTask)a.getKey()).level(), ((VisualizationTask)b.getKey()).level())).iterator();
        Node insertpos = null;
        while (it.hasNext()) {
            Map.Entry ent = (Map.Entry)it.next();
            VisualizationTask task = (VisualizationTask)ent.getKey();
            Visualization vis = (Visualization)ent.getValue();
            if (!task.isVisible()) {
                if (vis == null) continue;
                SVGUtil.removeFromParent(vis.getLayer());
                continue;
            }
            if (vis == null) {
                vis = this.instantiateVisualization(task);
                ent.setValue(vis);
            }
            Element layer = vis.getLayer();
            if (task.has(VisualizationTask.RenderFlag.NO_EXPORT)) {
                layer.setAttribute("noexport", "noexport");
            }
            if (layer.getParentNode() != this.getRoot()) {
                if (insertpos != null && insertpos.getNextSibling() != null) {
                    this.getRoot().insertBefore(layer, insertpos.getNextSibling());
                } else {
                    this.getRoot().appendChild(layer);
                }
            }
            updateStyle = true;
            insertpos = layer;
        }
        if (updateStyle) {
            this.updateStyleElement();
        }
    }

    private Visualization instantiateVisualization(VisualizationTask task) {
        try {
            Visualization v = task.getFactory().makeVisualization(this.context, task, this, this.width, this.height, this.item.proj);
            if (task.has(VisualizationTask.RenderFlag.NO_EXPORT)) {
                v.getLayer().setAttribute("noexport", "noexport");
            }
            return v;
        }
        catch (Exception e) {
            if (LOG.isDebugging()) {
                LOG.warning("Visualizer " + task.getFactory().getClass().getName() + " failed.", e);
            } else {
                LOG.warning("Visualizer " + task.getFactory().getClass().getName() + " failed - enable debugging to see details: " + e.toString());
            }
            return null;
        }
    }

    public void destroy() {
        this.context.removeVisualizationListener(this);
        this.context.removeResultListener(this);
        for (Map.Entry<VisualizationTask, Visualization> v : this.taskmap.entrySet()) {
            Visualization vis = v.getValue();
            if (vis == null) continue;
            vis.destroy();
        }
        this.taskmap.clear();
    }

    @Override
    public void dispose() {
        this.destroy();
        super.dispose();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    private void lazyRefresh() {
        Runnable pr = new Runnable(){

            @Override
            public void run() {
                if (DetailView.this.pendingRefresh.compareAndSet(this, null)) {
                    DetailView.this.refresh();
                }
            }
        };
        this.pendingRefresh.set(pr);
        this.scheduleUpdate(pr);
    }

    @Override
    public void resultAdded(Result child, Result parent) {
        this.lazyRefresh();
    }

    @Override
    public void resultChanged(Result current) {
        this.lazyRefresh();
    }

    @Override
    public void resultRemoved(Result child, Result parent) {
        this.lazyRefresh();
    }

    @Override
    public void visualizationChanged(VisualizationItem current) {
        if (!(current instanceof VisualizationTask)) {
            return;
        }
        VisualizationTask task = (VisualizationTask)current;
        Visualization vis = this.taskmap.get(task);
        if (vis == null) {
            boolean include = false;
            It<Projector> it = this.context.getVisHierarchy().iterAncestors(current).filter(Projector.class);
            while (it.valid()) {
                if (this.item.proj != null && this.item.proj.getProjector() == it.get()) {
                    include = true;
                    break;
                }
                it.advance();
            }
            if (!include) {
                return;
            }
            this.taskmap.put(task, null);
            this.lazyRefresh();
        }
    }

    @Override
    protected void redraw() {
        while (!this.updateQueue.isEmpty()) {
            ((Visualization)this.updateQueue.pop()).incrementalRedraw();
        }
        this.refresh();
    }

    public PlotItem getPlotItem() {
        return this.item;
    }
}

