/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.CSSHoverClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.detail.DetailView;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.DetailViewSelectedEvent;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.LayerMap;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.RectangleArranger;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class OverviewPlot
implements ResultListener,
VisualizationListener {
    private static final Logging LOG = Logging.getLogger(OverviewPlot.class);
    public static final String OVERVIEW_REFRESHING = "Overview refreshing";
    public static final String OVERVIEW_REFRESHED = "Overview refreshed";
    private static final boolean DEBUG_LAYOUT = false;
    private VisualizerContext context;
    private VisualizationPlot plot;
    protected RectangleArranger<PlotItem> plotmap;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean single;
    public int screenwidth = 2000;
    public int screenheight = 2000;
    private EventListener hoverer;
    private LayerMap vistoelem = new LayerMap();
    private Element plotlayer;
    private Element hoverlayer;
    private CSSClass selcss;
    private double ratio = 1.0;
    AtomicReference<Runnable> pendingRefresh = new AtomicReference<Object>(null);
    private boolean reinitOnRefresh = false;

    public OverviewPlot(VisualizerContext context, boolean single) {
        this.context = context;
        this.single = single;
    }

    private RectangleArranger<PlotItem> arrangeVisualizations(double width, double height) {
        if (!(width > 0.0) || !(height > 0.0)) {
            LOG.warning("No size information during arrange()", new Throwable());
            return new RectangleArranger<PlotItem>(1.0, 1.0);
        }
        RectangleArranger<PlotItem> plotmap = new RectangleArranger<PlotItem>(width, height);
        VisualizationTree vistree = this.context.getVisHierarchy();
        It<VisualizationItem> iter2 = vistree.iterAll().filter(Projector.class);
        while (iter2.valid()) {
            Collection<PlotItem> projs = iter2.get().arrange(this.context);
            for (PlotItem it : projs) {
                if (it.w <= 0.0 || it.h <= 0.0) {
                    LOG.warning("Plot item with improper size information: " + it);
                    continue;
                }
                plotmap.put(it.w, it.h, it);
            }
            iter2.advance();
        }
        iter2 = vistree.iterAll().filter(VisualizationTask.class);
        while (iter2.valid()) {
            VisualizationTask task = (VisualizationTask)iter2.get();
            if (task.isVisible() && !vistree.iterParents(task).filter(Projector.class).valid()) {
                if (task.getRequestedWidth() <= 0.0 || task.getRequestedHeight() <= 0.0) {
                    LOG.warning("Task with improper size information: " + task);
                } else {
                    PlotItem it = new PlotItem(task.getRequestedWidth(), task.getRequestedHeight(), null);
                    it.tasks.add(task);
                    plotmap.put(it.w, it.h, it);
                }
            }
            iter2.advance();
        }
        return plotmap;
    }

    public void initialize(double ratio) {
        if (!(ratio > 0.0) || !(ratio < Double.POSITIVE_INFINITY)) {
            LOG.warning("Invalid ratio: " + ratio, new Throwable());
            ratio = 1.4;
        }
        this.ratio = ratio;
        if (this.plot != null) {
            LOG.warning("Already initialized.");
            this.lazyRefresh();
            return;
        }
        this.reinitialize();
        this.context.addResultListener(this);
        this.context.addVisualizationListener(this);
    }

    private synchronized void reinitialize() {
        if (this.plot == null) {
            this.initializePlot();
        } else {
            ActionEvent ev = new ActionEvent(this, 1001, OVERVIEW_REFRESHING);
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(ev);
            }
        }
        for (Pair pair : this.vistoelem.values()) {
            SVGUtil.removeFromParent((Element)pair.first);
        }
        this.plotmap = this.arrangeVisualizations(this.ratio, 1.0);
        this.recalcViewbox();
        int thumbsize = (int)Math.max((double)this.screenwidth / this.plotmap.getWidth(), (double)this.screenheight / this.plotmap.getHeight());
        LayerMap layerMap = this.vistoelem;
        this.vistoelem = new LayerMap();
        SVGUtil.removeFromParent(this.plotlayer);
        SVGUtil.removeFromParent(this.hoverlayer);
        this.plotlayer = this.plot.svgElement("g");
        this.hoverlayer = this.plot.svgElement("g");
        this.hoverlayer.setAttribute("noexport", "noexport");
        for (Map.Entry<PlotItem, double[]> entry : this.plotmap.entrySet()) {
            double basex = entry.getValue()[0];
            double basey = entry.getValue()[1];
            Iterator<PlotItem> iter = entry.getKey().itemIterator();
            while (iter.hasNext()) {
                PlotItem it = iter.next();
                boolean hasDetails = false;
                Element g = this.plot.svgElement("g");
                SVGUtil.setAtt(g, "transform", "translate(" + (basex + it.x) + " " + (basey + it.y) + ")");
                this.plotlayer.appendChild(g);
                this.vistoelem.put(it, null, g, null);
                for (VisualizationTask task : it.tasks) {
                    if (!this.visibleInOverview(task)) continue;
                    hasDetails |= !task.has(VisualizationTask.RenderFlag.NO_DETAIL);
                    Pair<Element, Visualization> pair = layerMap.remove(it, task);
                    if (pair == null) {
                        pair = new Pair<Element, Object>(this.plot.svgElement("g"), null);
                    }
                    if (pair.second == null) {
                        pair.second = this.embedOrThumbnail(thumbsize, it, task, (Element)pair.first);
                    }
                    g.appendChild((Node)pair.first);
                    this.vistoelem.put(it, task, pair);
                }
                if (!hasDetails || this.single) continue;
                Element hover = this.plot.svgRect(basex + it.x, basey + it.y, it.w, it.h);
                SVGUtil.addCSSClass(hover, this.selcss.getName());
                EventTarget targ = (EventTarget)((Object)hover);
                targ.addEventListener("mouseover", this.hoverer, false);
                targ.addEventListener("mouseout", this.hoverer, false);
                targ.addEventListener("click", this.hoverer, false);
                targ.addEventListener("click", evt -> this.triggerSubplotSelectEvent(it), false);
                this.hoverlayer.appendChild(hover);
            }
        }
        for (Pair<Element, Visualization> pair : layerMap.values()) {
            if (pair.second == null) continue;
            ((Visualization)pair.second).destroy();
        }
        this.plot.getRoot().appendChild(this.plotlayer);
        this.plot.getRoot().appendChild(this.hoverlayer);
        this.plot.updateStyleElement();
        ActionEvent actionEvent = new ActionEvent(this, 1001, OVERVIEW_REFRESHED);
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void initializePlot() {
        this.plot = new VisualizationPlot();
        CSSClass cls = new CSSClass(this, "background");
        String bgcol = this.context.getStyleLibrary().getBackgroundColor("page");
        cls.setStatement("fill", bgcol);
        this.plot.addCSSClassOrLogError(cls);
        Element background = this.plot.svgElement("rect");
        background.setAttribute("x", "0");
        background.setAttribute("y", "0");
        background.setAttribute("width", "100%");
        background.setAttribute("height", "100%");
        SVGUtil.setCSSClass(background, cls.getName());
        if ("white".equals(bgcol)) {
            background.setAttribute("noexport", "noexport");
        }
        this.plot.getRoot().appendChild(background);
        this.selcss = new CSSClass(this, "s");
        this.selcss.setStatement("fill", "red");
        this.selcss.setStatement("fill-opacity", "0");
        this.selcss.setStatement("cursor", "pointer");
        this.plot.addCSSClassOrLogError(this.selcss);
        CSSClass hovcss = new CSSClass(this, "h");
        hovcss.setStatement("fill-opacity", "0.25");
        this.plot.addCSSClassOrLogError(hovcss);
        this.hoverer = new CSSHoverClass(hovcss.getName(), null, true);
        if (this.single) {
            this.plot.setDisableInteractions(true);
        }
        SVGEffects.addShadowFilter(this.plot);
        SVGEffects.addLightGradient(this.plot);
    }

    private Visualization embedOrThumbnail(int thumbsize, PlotItem it, VisualizationTask task, Element parent) {
        Visualization vis = !this.single ? task.getFactory().makeVisualizationOrThumbnail(this.context, task, this.plot, it.w, it.h, it.proj, thumbsize) : task.getFactory().makeVisualization(this.context, task, this.plot, it.w, it.h, it.proj);
        if (vis == null || vis.getLayer() == null) {
            LOG.warning("Visualization returned empty layer: " + vis);
            return vis;
        }
        if (task.has(VisualizationTask.RenderFlag.NO_EXPORT)) {
            vis.getLayer().setAttribute("noexport", "noexport");
        }
        parent.appendChild(vis.getLayer());
        return vis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refresh() {
        if (this.reinitOnRefresh) {
            LOG.debug("Reinitialize in thread " + Thread.currentThread().getName());
            this.reinitialize();
            this.reinitOnRefresh = false;
            return;
        }
        VisualizationPlot visualizationPlot = this.plot;
        synchronized (visualizationPlot) {
            boolean refreshcss = false;
            if (this.plotmap == null) {
                throw new IllegalStateException("Plotmap is null");
            }
            int thumbsize = (int)Math.max((double)this.screenwidth / this.plotmap.getWidth(), (double)this.screenheight / this.plotmap.getHeight());
            for (PlotItem pi : this.plotmap.keySet()) {
                Iterator<PlotItem> iter = pi.itemIterator();
                while (iter.hasNext()) {
                    PlotItem it = iter.next();
                    for (VisualizationTask task : it.tasks) {
                        Pair<Element, Visualization> pair = this.vistoelem.get(it, task);
                        if (pair == null) {
                            if (!this.visibleInOverview(task)) continue;
                            Element elem = this.plot.svgElement("g");
                            pair = new Pair<Element, Visualization>(elem, this.embedOrThumbnail(thumbsize, it, task, elem));
                            ((Element)this.vistoelem.get((PlotItem)it, null).first).appendChild(elem);
                            this.vistoelem.put(it, task, pair);
                            refreshcss = true;
                            continue;
                        }
                        if (pair.first == null) continue;
                        if (this.visibleInOverview(task)) {
                            if (!((Element)pair.first).hasAttribute("visibility")) continue;
                            ((Element)pair.first).removeAttribute("visibility");
                            continue;
                        }
                        if (!((Element)pair.first).hasChildNodes()) continue;
                        ((Element)pair.first).setAttribute("visibility", "hidden");
                    }
                }
            }
            if (refreshcss) {
                this.plot.updateStyleElement();
            }
        }
    }

    protected boolean visibleInOverview(VisualizationTask task) {
        return task.isVisible() && !task.has(this.single ? VisualizationTask.RenderFlag.NO_EMBED : VisualizationTask.RenderFlag.NO_THUMBNAIL);
    }

    private void recalcViewbox() {
        Element root = this.plot.getRoot();
        SVGUtil.setAtt(root, "width", "20cm");
        SVGUtil.setAtt(root, "height", SVGUtil.fmt(20.0 * this.plotmap.getHeight() / this.plotmap.getWidth()) + "cm");
        String vb = "0 0 " + SVGUtil.fmt(this.plotmap.getWidth()) + " " + SVGUtil.fmt(this.plotmap.getHeight());
        SVGUtil.setAtt(root, "viewBox", vb);
    }

    public DetailView makeDetailView(PlotItem it) {
        return new DetailView(this.context, it, this.ratio);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    protected void triggerSubplotSelectEvent(PlotItem it) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new DetailViewSelectedEvent(this, 1001, null, 0, it));
        }
    }

    public void destroy() {
        this.context.removeVisualizationListener(this);
        this.context.removeResultListener(this);
        this.plot.dispose();
    }

    public SVGPlot getPlot() {
        return this.plot;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        if (ratio != this.ratio) {
            this.ratio = ratio;
            this.reinitOnRefresh = true;
            this.lazyRefresh();
        }
    }

    public final void lazyRefresh() {
        if (this.plot == null) {
            LOG.warning("'lazyRefresh' called before initialized!");
            return;
        }
        LOG.debug("Scheduling refresh.");
        Runnable pr = new Runnable(){

            @Override
            public void run() {
                if (OverviewPlot.this.pendingRefresh.compareAndSet(this, null)) {
                    OverviewPlot.this.refresh();
                }
            }
        };
        this.pendingRefresh.set(pr);
        this.plot.scheduleUpdate(pr);
    }

    @Override
    public void resultAdded(Result child, Result parent) {
        this.lazyRefresh();
    }

    @Override
    public void resultChanged(Result current) {
        this.lazyRefresh();
    }

    @Override
    public void resultRemoved(Result child, Result parent) {
        this.lazyRefresh();
    }

    @Override
    public void visualizationChanged(VisualizationItem child) {
        if (!this.context.getVisHierarchy().iterParents(child).filter(Projector.class).valid()) {
            this.reinitOnRefresh = true;
        }
        this.lazyRefresh();
    }
}

