/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PlotItem {
    public final double x;
    public final double y;
    public final double w;
    public final double h;
    public final Projection proj;
    public List<VisualizationTask> tasks = new LinkedList<VisualizationTask>();
    public Collection<PlotItem> subitems = new LinkedList<PlotItem>();

    public PlotItem(double w, double h, Projection proj) {
        this(0.0, 0.0, w, h, proj);
    }

    public PlotItem(double x, double y, double w, double h, Projection proj) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.proj = proj;
    }

    public PlotItem(PlotItem vis) {
        this.x = vis.x;
        this.y = vis.y;
        this.w = vis.w;
        this.h = vis.h;
        this.proj = vis.proj;
        this.tasks = new ArrayList<VisualizationTask>(vis.tasks);
        this.subitems = new ArrayList<PlotItem>(vis.subitems.size());
        for (PlotItem s : vis.subitems) {
            this.subitems.add(new PlotItem(s));
        }
    }

    public void sort() {
        Collections.sort(this.tasks);
        for (PlotItem subitem : this.subitems) {
            subitem.sort();
        }
    }

    public void add(VisualizationTask task) {
        this.tasks.add(task);
    }

    public int taskSize() {
        return this.tasks.size();
    }

    public Iterator<PlotItem> itemIterator() {
        return new ItmItr();
    }

    public String toString() {
        return "PlotItem [x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ",proj=" + this.proj + "]";
    }

    private class ItmItr
    implements Iterator<PlotItem> {
        PlotItem next;
        Iterator<PlotItem> cur;
        Iterator<PlotItem> sub;

        public ItmItr() {
            this.next = PlotItem.this;
            this.cur = null;
            this.sub = PlotItem.this.subitems.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.cur != null && this.cur.hasNext()) {
                this.next = this.cur.next();
                return true;
            }
            if (this.sub.hasNext()) {
                this.cur = this.sub.next().itemIterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public PlotItem next() {
            this.hasNext();
            PlotItem ret = this.next;
            this.next = null;
            return ret;
        }
    }
}

