/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RectangleArranger<T> {
    private static final Logging LOG = Logging.getLogger(RectangleArranger.class);
    private double ratio = 1.0;
    private double twidth = 1.0;
    private double theight = 1.0;
    private DoubleArray widths = new DoubleArray();
    private DoubleArray heights = new DoubleArray();
    private ArrayList<ArrayList<Object>> usage = new ArrayList();
    private Map<T, double[]> map = new HashMap<T, double[]>();

    public RectangleArranger(double ratio) {
        this(ratio, 1.0);
    }

    public RectangleArranger(double width, double height) {
        this.ratio = width / height;
        this.twidth = width;
        this.theight = height;
        this.widths.add(width);
        this.heights.add(height);
        ArrayList<Object> u = new ArrayList<Object>();
        u.add(null);
        this.usage.add(u);
        this.assertConsistent();
    }

    public void put(double w, double h, T data) {
        double bestinc;
        double besthi;
        double bestwi;
        double i2;
        if (LOG.isDebuggingFinest()) {
            LOG.finest("Add: " + w + "x" + h);
        }
        int cols = this.widths.size();
        int rows = this.heights.size();
        int bestsx = -1;
        int bestsy = -1;
        int bestex = cols - 1;
        int bestey = -1;
        double i1 = this.computeIncreaseArea(w, Math.max(0.0, h - this.theight));
        if (i1 < (i2 = this.computeIncreaseArea(Math.max(0.0, w - this.twidth), h))) {
            bestwi = w;
            besthi = Math.max(0.0, h - this.theight);
            bestinc = i1;
        } else {
            bestwi = Math.max(0.0, w - this.twidth);
            besthi = h;
            bestinc = i2;
        }
        for (int sy = 0; sy < rows; ++sy) {
            for (int sx = 0; sx < cols; ++sx) {
                if (this.usage.get(sy).get(sx) != null) continue;
                double avw = this.widths.get(sx);
                double avh = this.heights.get(sy);
                int ex = sx;
                int ey = sy;
                while (avw < w || avh < h) {
                    int x;
                    int y;
                    boolean ok;
                    if (avw / avh < w / h) {
                        if (avw < w && ex + 1 < cols) {
                            ok = true;
                            for (y = sy; y <= ey; ++y) {
                                if (this.usage.get(y).get(ex + 1) == null) continue;
                                ok = false;
                            }
                            if (ok) {
                                avw += this.widths.get(++ex);
                                continue;
                            }
                        }
                        if (!(avh < h) || ey + 1 >= rows) break;
                        ok = true;
                        for (x = sx; x <= ex; ++x) {
                            if (this.usage.get(ey + 1).get(x) == null) continue;
                            ok = false;
                        }
                        if (!ok) break;
                        avh += this.heights.get(++ey);
                        continue;
                    }
                    if (avh < h && ey + 1 < rows) {
                        ok = true;
                        for (x = sx; x <= ex; ++x) {
                            if (this.usage.get(ey + 1).get(x) == null) continue;
                            ok = false;
                        }
                        if (ok) {
                            avh += this.heights.get(++ey);
                            continue;
                        }
                    }
                    if (!(avw < w) || ex + 1 >= cols) break;
                    ok = true;
                    for (y = sy; y <= ey; ++y) {
                        if (this.usage.get(y).get(ex + 1) == null) continue;
                        ok = false;
                    }
                    if (!ok) break;
                    avw += this.widths.get(++ex);
                }
                if (avw < w && ex < cols - 1 || avh < h && ey < rows - 1) continue;
                double winc = Math.max(0.0, w - avw);
                double hinc = Math.max(0.0, h - avh);
                double inc = this.computeIncreaseArea(winc, hinc);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("Candidate: " + sx + "," + sy + " - " + ex + "," + ey + ": " + avw + "x" + avh + " " + inc);
                }
                if (inc < bestinc) {
                    bestinc = inc;
                    bestsx = sx;
                    bestsy = sy;
                    bestex = ex;
                    bestey = ey;
                    bestwi = w - avw;
                    besthi = h - avh;
                }
                if (inc == 0.0) break;
            }
            assert (this.assertConsistent());
        }
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Best: " + bestsx + "," + bestsy + " - " + bestex + "," + bestey + " inc: " + bestwi + "x" + besthi + " " + bestinc);
        }
        if (bestinc > 0.0) {
            assert (bestex == cols - 1 || bestey == rows - 1);
            double inc = Math.max(bestwi, besthi * this.ratio);
            this.resize(inc);
            this.put(w, h, data);
            return;
        }
        if (bestwi < 0.0) {
            this.splitCol(bestex, -bestwi);
            bestwi = 0.0;
        }
        if (besthi < 0.0) {
            this.splitRow(bestey, -besthi);
            besthi = 0.0;
        }
        for (int x = bestsx; x <= bestex; ++x) {
            for (int y = bestsy; y <= bestey; ++y) {
                this.usage.get(y).set(x, data);
            }
        }
        double xpos = 0.0;
        double ypos = 0.0;
        for (int x = 0; x < bestsx; ++x) {
            xpos += this.widths.get(x);
        }
        for (int y = 0; y < bestsy; ++y) {
            ypos += this.heights.get(y);
        }
        this.map.put(data, new double[]{xpos, ypos, w, h});
        if (LOG.isDebuggingFinest()) {
            this.logSizes();
        }
    }

    protected double computeIncreaseArea(double winc, double hinc) {
        double inc = Math.max(winc, hinc * this.ratio);
        inc *= hinc + inc / this.ratio + winc / this.ratio;
        return inc;
    }

    protected void splitRow(int bestey, double besthi) {
        assert (bestey < this.heights.size());
        if (this.heights.get(bestey) - besthi <= Double.MIN_NORMAL) {
            return;
        }
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Split row " + bestey);
        }
        this.heights.insert(bestey + 1, besthi);
        this.heights.set(bestey, this.heights.get(bestey) - besthi);
        this.usage.add(bestey + 1, new ArrayList(this.usage.get(bestey)));
    }

    protected void splitCol(int bestex, double bestwi) {
        assert (bestex < this.widths.size());
        if (this.widths.get(bestex) - bestwi <= Double.MIN_NORMAL) {
            return;
        }
        int rows = this.heights.size();
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Split column " + bestex);
        }
        this.widths.insert(bestex + 1, bestwi);
        this.widths.set(bestex, this.widths.get(bestex) - bestwi);
        for (int y = 0; y < rows; ++y) {
            this.usage.get(y).add(bestex + 1, this.usage.get(y).get(bestex));
        }
        assert (this.assertConsistent());
    }

    private void resize(double inc) {
        int cols = this.widths.size();
        int rows = this.heights.size();
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Resize by " + inc + "x" + inc / this.ratio);
            if (LOG.isDebuggingFinest()) {
                this.logSizes();
            }
        }
        this.widths.add(inc);
        this.twidth += inc;
        this.heights.add(inc / this.ratio);
        this.theight += inc / this.ratio;
        for (int y = 0; y < rows; ++y) {
            this.usage.get(y).add(null);
        }
        ArrayList<Object> row = new ArrayList<Object>();
        for (int x = 0; x <= cols; ++x) {
            row.add(null);
        }
        this.usage.add(row);
        assert (this.assertConsistent());
        if (LOG.isDebuggingFinest()) {
            this.logSizes();
        }
    }

    public double[] get(T object) {
        double[] v = this.map.get(object);
        if (v == null) {
            return null;
        }
        return (double[])v.clone();
    }

    private boolean assertConsistent() {
        int cols = this.widths.size();
        int rows = this.heights.size();
        double wsum = 0.0;
        for (int x = 0; x < cols; ++x) {
            assert (this.widths.get(x) > 0.0) : "Non-positive width: " + this.widths.get(x) + " at " + x;
            wsum += this.widths.get(x);
        }
        assert (Math.abs(wsum - this.twidth) < 1.0E-10);
        double hsum = 0.0;
        for (int y = 0; y < rows; ++y) {
            assert (this.heights.get(y) > 0.0) : "Non-positive height: " + this.heights.get(y) + " at " + y;
            hsum += this.heights.get(y);
        }
        assert (Math.abs(hsum - this.theight) < 1.0E-10);
        assert (this.usage.size() == rows);
        for (int y = 0; y < rows; ++y) {
            assert (this.usage.get(y).size() == cols);
        }
        return true;
    }

    protected void logSizes() {
        int y;
        int x;
        StringBuilder buf = new StringBuilder(1000);
        int cols = this.widths.size();
        int rows = this.heights.size();
        buf.append("Widths: ");
        for (x = 0; x < cols; ++x) {
            if (x > 0) {
                buf.append(", ");
            }
            buf.append(this.widths.get(x));
        }
        buf.append('\n');
        buf.append("Heights: ");
        for (y = 0; y < rows; ++y) {
            if (y > 0) {
                buf.append(", ");
            }
            buf.append(this.heights.get(y));
        }
        buf.append('\n');
        for (y = 0; y < rows; ++y) {
            for (int x2 = 0; x2 < cols; ++x2) {
                buf.append(this.usage.get(y).get(x2) != null ? (char)'X' : '_');
            }
            buf.append("|\n");
        }
        for (x = 0; x < cols; ++x) {
            buf.append('-');
        }
        buf.append("+\n");
        LOG.debug(buf);
    }

    public double relativeFill() {
        double acc = 0.0;
        int cols = this.widths.size();
        int rows = this.heights.size();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                if (this.usage.get(y).get(x) == null) continue;
                acc += this.widths.get(x) * this.heights.get(y);
            }
        }
        return acc / (this.twidth * this.theight);
    }

    public double getWidth() {
        return this.twidth;
    }

    public double getHeight() {
        return this.theight;
    }

    public Set<Map.Entry<T, double[]>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public Set<T> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public static void main(String[] args) {
        LoggingConfiguration.setLevelFor(RectangleArranger.class.getName(), Level.FINEST.getName());
        RectangleArranger<String> r = new RectangleArranger<String>(1.3);
        r.put(4.0, 1.0, "Histogram");
        r.put(4.0, 4.0, "3D view");
        r.put(1.0, 1.0, "Meta 1");
        r.put(1.0, 1.0, "Meta 2");
        r.put(1.0, 1.0, "Meta 3");
        r.put(2.0, 2.0, "Meta 4");
        r.put(2.0, 2.0, "Meta 5");
        r = new RectangleArranger(3.0, 3.0);
        r.put(1.0, 2.0, "A");
        r.put(2.0, 1.0, "B");
        r.put(1.0, 2.0, "C");
        r.put(2.0, 1.0, "D");
        r.put(2.0, 2.0, "E");
        r = new RectangleArranger(1.3478260869565215);
        r.put(4.0, 0.5, "A");
        r.put(4.0, 3.0, "B");
        r.put(4.0, 1.0, "C");
        r.put(1.0, 0.1, "D");
    }
}

