/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.opticsplot;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;

public final class OPTICSCut {
    private OPTICSCut() {
    }

    public static <E extends ClusterOrder> Clustering<Model> makeOPTICSCut(E co, double epsilon) {
        Clustering<Model> clustering = new Clustering<Model>("OPTICS Cut Clustering", "optics-cut");
        HashSetModifiableDBIDs noise = DBIDUtil.newHashSet();
        double lastDist = Double.MAX_VALUE;
        double actDist = Double.MAX_VALUE;
        HashSetModifiableDBIDs current = DBIDUtil.newHashSet();
        DBIDVar prev = DBIDUtil.newVar();
        DBIDArrayIter it = co.iter();
        while (it.valid()) {
            lastDist = actDist;
            actDist = co.getReachability(it);
            if (actDist <= epsilon) {
                if (lastDist > epsilon && prev.isSet()) {
                    noise.remove(prev);
                    current.add(prev);
                }
                current.add(it);
            } else {
                if (!current.isEmpty()) {
                    clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)current, ClusterModel.CLUSTER));
                    current = DBIDUtil.newHashSet();
                }
                noise.add(it);
            }
            prev.set(it);
            it.advance();
        }
        if (!current.isEmpty()) {
            clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)current, ClusterModel.CLUSTER));
        }
        clustering.addToplevelCluster(new Cluster<ClusterModel>(noise, true, ClusterModel.CLUSTER));
        return clustering;
    }
}

