/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.opticsplot;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

public class OPTICSPlot
implements Result {
    private static final Logging LOG = Logging.getLogger(OPTICSPlot.class);
    private static final int MIN_HEIGHT = 25;
    private static final int MAX_HEIGHT = 300;
    LinearScale scale;
    int width;
    int height;
    double ratio;
    final ClusterOrder co;
    final StylingPolicy colors;
    protected RenderedImage plot;
    protected int plotnum = -1;

    public OPTICSPlot(ClusterOrder co, StylingPolicy colors) {
        this.co = co;
        this.colors = colors;
    }

    public void replot() {
        this.width = this.co.size();
        this.height = (int)Math.ceil((double)this.width * 0.2);
        this.ratio = (double)this.width / (double)this.height;
        int n = this.height < 25 ? 25 : (this.height = this.height > 300 ? 300 : this.height);
        if (this.scale == null) {
            this.scale = this.computeScale(this.co);
        }
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        int x = 0;
        DBIDArrayIter it = this.co.iter();
        while (it.valid()) {
            double reach = this.co.getReachability(it);
            int y = this.scaleToPixel(reach);
            try {
                int col = this.colors.getColorForDBID(it);
                for (int y2 = this.height - 1; y2 >= y; --y2) {
                    img.setRGB(x, y2, col);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("Plotting out of range: " + x + "," + y + " >= " + this.width + "x" + this.height);
            }
            ++x;
            it.advance();
        }
        this.plot = img;
    }

    public int scaleToPixel(double reach) {
        return Double.isInfinite(reach) || Double.isNaN(reach) ? 0 : (int)Math.round(this.scale.getScaled(reach, (double)this.height - 0.5, 0.5));
    }

    public double scaleFromPixel(double y) {
        return this.scale.getUnscaled((y - 0.5) / ((double)this.height - 1.0));
    }

    protected LinearScale computeScale(ClusterOrder order) {
        DoubleMinMax range = new DoubleMinMax();
        DBIDArrayIter it = order.iter();
        while (it.valid()) {
            double reach = this.co.getReachability(it);
            if (reach < Double.POSITIVE_INFINITY) {
                range.put(reach);
            }
            it.advance();
        }
        if (!range.isValid()) {
            range.put(0.0);
            range.put(1.0);
        }
        return new LinearScale(range.getMin(), range.getMax());
    }

    public LinearScale getScale() {
        if (this.plot == null) {
            this.replot();
        }
        return this.scale;
    }

    public int getWidth() {
        if (this.plot == null) {
            this.replot();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.plot == null) {
            this.replot();
        }
        return this.height;
    }

    public double getRatio() {
        if (this.plot == null) {
            this.replot();
        }
        return this.ratio;
    }

    public synchronized RenderedImage getPlot() {
        if (this.plot == null) {
            this.replot();
        }
        return this.plot;
    }

    public void forgetRenderedImage() {
        this.plotnum = -1;
        this.plot = null;
    }

    public String getSVGPlotURI() {
        if (this.plotnum < 0) {
            this.plotnum = ThumbnailRegistryEntry.registerImage(this.plot);
        }
        return "thumb:" + this.plotnum;
    }

    @Override
    public String getLongName() {
        return "OPTICS Plot";
    }

    @Override
    public String getShortName() {
        return "optics plot";
    }

    public static OPTICSPlot plotForClusterOrder(ClusterOrder co, VisualizerContext context) {
        StylingPolicy policy = context.getStylingPolicy();
        OPTICSPlot opticsplot = new OPTICSPlot(co, policy);
        return opticsplot;
    }

    public ClusterOrder getClusterOrder() {
        return this.co;
    }
}

