/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d;

import com.jogamp.opengl.util.awt.TextRenderer;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.evaluation.AutomaticEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.EmptyParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.Parallel3DRenderer;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.AbstractLayout3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layout;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layouter3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.SimilarityBasedLayouter3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.SimpleCircularMSTLayout3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.Arcball1DOFAdapter;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.Simple1DOFCamera;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.SimpleMenuOverlay;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.SimpleMessageOverlay;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.projections.SimpleParallel;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.PropertiesBasedStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@Alias(value={"3dpc", "3DPC"})
@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class OpenGL3DParallelCoordinates<O extends NumberVector>
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(OpenGL3DParallelCoordinates.class);
    Settings<O> settings = new Settings();

    public OpenGL3DParallelCoordinates(Layouter3DPC<? super O> layout) {
        this.settings.layout = layout;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        List<Relation<?>> rels = ResultUtil.getRelations(newResult);
        for (Relation<?> rel : rels) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) continue;
            Relation<?> vrel = rel;
            ScalesResult scales = ScalesResult.getScalesResult(vrel);
            SimpleParallel proj = new SimpleParallel(null, scales.getScales());
            PropertiesBasedStyleLibrary stylelib = new PropertiesBasedStyleLibrary();
            StylingPolicy stylepol = this.getStylePolicy(hier, stylelib);
            new Instance(vrel, proj, this.settings, stylepol, stylelib).run();
        }
    }

    public StylingPolicy getStylePolicy(ResultHierarchy hier, StyleLibrary stylelib) {
        Database db = ResultUtil.findDatabase(hier);
        AutomaticEvaluation.ensureClusteringResult(db, db);
        List<Clustering<Model>> clusterings = Clustering.getClusteringResults(db);
        if (clusterings.isEmpty()) {
            throw new AbortException("No clustering result generated?!?");
        }
        return new ClusterStylingPolicy(clusterings.get(0), stylelib);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID LAYOUT_ID = new OptionID("parallel3d.layout", "Layouting method for 3DPC.");
        Layouter3DPC<O> layout;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter layoutP = new ObjectParameter(LAYOUT_ID, (Class<?>)Layouter3DPC.class, SimpleCircularMSTLayout3DPC.class);
            if (config.grab(layoutP)) {
                this.layout = (Layouter3DPC)layoutP.instantiateClass(config);
            }
        }

        @Override
        protected OpenGL3DParallelCoordinates<O> makeInstance() {
            return new OpenGL3DParallelCoordinates<O>(this.layout);
        }
    }

    public static class Instance<O extends NumberVector>
    implements GLEventListener {
        static final boolean DEBUG = false;
        JFrame frame = null;
        GLU glu;
        private Parallel3DRenderer<O> prenderer;
        GLCanvas canvas;
        Arcball1DOFAdapter arcball;
        SimpleMenuOverlay menuOverlay;
        SimpleMessageOverlay messageOverlay;
        MouseAdapter menuStarter;
        State state = State.PREPARATION;
        Shared<O> shared = new Shared();

        public Instance(Relation<? extends O> rel, ProjectionParallel proj, Settings<O> settings, StylingPolicy stylepol, StyleLibrary stylelib) {
            this.shared.dim = RelationUtil.dimensionality(rel);
            this.shared.rel = rel;
            this.shared.proj = proj;
            this.shared.stylelib = stylelib;
            this.shared.stylepol = stylepol;
            this.shared.settings = settings;
            this.shared.labels = new String[this.shared.dim];
            VectorFieldTypeInformation<O> vrel = RelationUtil.assumeVectorField(rel);
            for (int i = 0; i < this.shared.dim; ++i) {
                this.shared.labels[i] = vrel.getLabel(i);
            }
            this.prenderer = new Parallel3DRenderer<O>(this.shared);
            this.menuOverlay = new SimpleMenuOverlay(){

                @Override
                public void menuItemClicked(int item) {
                    if (item < 0) {
                        this.switchState(State.EXPLORE);
                        return;
                    }
                    String name = menuOverlay.getOptions().get(item);
                    if (name == null) {
                        this.switchState(State.EXPLORE);
                        return;
                    }
                    LOG.debug("Relayout chosen: " + name);
                    this.relayout(name);
                }
            };
            this.menuStarter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (State.EXPLORE.equals((Object)state) && e.getButton() == 3) {
                        this.switchState(State.MENU);
                    }
                }
            };
            this.messageOverlay = new SimpleMessageOverlay();
            ArrayList<String> options = this.menuOverlay.getOptions();
            for (Class<?> clz : ELKIServiceRegistry.findAllImplementations(Layouter3DPC.class)) {
                options.add(clz.getSimpleName());
            }
            if (options.size() > 0) {
                options.add(null);
            }
            for (Class<?> clz : ELKIServiceRegistry.findAllImplementations(DependenceMeasure.class)) {
                options.add(clz.getSimpleName());
            }
            GLProfile glp = GLProfile.getDefault();
            GLCapabilities caps = new GLCapabilities(glp);
            caps.setDoubleBuffered(true);
            this.canvas = new GLCanvas(caps);
            this.canvas.addGLEventListener(this);
            this.frame = new JFrame("ELKI 3D Parallel Coordinate Visualization");
            this.frame.setSize(600, 600);
            this.frame.add(this.canvas);
        }

        void initLabels() {
            this.shared.labels = new String[this.shared.dim];
            for (int i = 0; i < this.shared.dim; ++i) {
                this.shared.labels[i] = RelationUtil.getColumnLabel(this.shared.rel, i);
            }
        }

        protected void relayout(String parname) {
            try {
                Class<Layouter3DPC> layoutc = ELKIServiceRegistry.findImplementation(Layouter3DPC.class, parname);
                if (layoutc != null) {
                    ListParameterization params = new ListParameterization();
                    if (this.shared.settings.sim != null) {
                        params.addParameter(SimilarityBasedLayouter3DPC.SIM_ID, (Object)this.shared.settings.sim);
                    }
                    this.shared.settings.layout = ClassGenericsUtil.tryInstantiate(Layouter3DPC.class, layoutc, params);
                    this.switchState(State.PREPARATION);
                    this.startLayoutThread();
                    return;
                }
            }
            catch (Exception e) {
                LOG.exception(e);
            }
            try {
                Class<DependenceMeasure> simc = ELKIServiceRegistry.findImplementation(DependenceMeasure.class, parname);
                if (simc != null) {
                    this.shared.settings.sim = ClassGenericsUtil.tryInstantiate(DependenceMeasure.class, simc, new EmptyParameterization());
                    if (!(this.shared.settings.layout instanceof SimilarityBasedLayouter3DPC)) {
                        ListParameterization params = new ListParameterization();
                        params.addParameter(SimilarityBasedLayouter3DPC.SIM_ID, (Object)this.shared.settings.sim);
                        this.shared.settings.layout = ClassGenericsUtil.tryInstantiate(Layouter3DPC.class, SimpleCircularMSTLayout3DPC.class, params);
                    }
                    this.shared.mat = null;
                    this.switchState(State.PREPARATION);
                    this.startLayoutThread();
                    return;
                }
            }
            catch (Exception e) {
                LOG.exception(e);
            }
            LOG.warning("Menu parameter did not map to a class name - wrong package?");
        }

        private void startLayoutThread() {
            new Thread(){

                @Override
                public void run() {
                    messageOverlay.setMessage("Computing axis similarities and layout...");
                    if (shared.settings.sim != null && shared.settings.layout instanceof SimilarityBasedLayouter3DPC) {
                        SimilarityBasedLayouter3DPC layouter = (SimilarityBasedLayouter3DPC)shared.settings.layout;
                        if (shared.mat == null) {
                            messageOverlay.setMessage("Recomputing similarity matrix.");
                            shared.mat = AbstractLayout3DPC.computeSimilarityMatrix(shared.settings.sim, shared.rel);
                        }
                        messageOverlay.setMessage("Recomputing layout using similarity matrix.");
                        Layout newlayout = layouter.layout(shared.dim, shared.mat);
                        this.setLayout(newlayout);
                    } else {
                        messageOverlay.setMessage("Recomputing layout.");
                        Layout newlayout = shared.settings.layout.layout(shared.rel);
                        this.setLayout(newlayout);
                    }
                }
            }.start();
        }

        public void run() {
            assert (this.frame != null);
            this.frame.setVisible(true);
            this.frame.setDefaultCloseOperation(2);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    this.stop();
                }
            });
            this.startLayoutThread();
        }

        public void stop() {
            this.frame = null;
        }

        @Override
        public void init(GLAutoDrawable drawable) {
            GL2 gl = drawable.getGL().getGL2();
            gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glDisable(2929);
            gl.glDisable(2884);
            this.glu = new GLU();
            this.shared.camera = new Simple1DOFCamera(this.glu);
            this.shared.camera.addCameraListener(new Simple1DOFCamera.CameraListener(){

                @Override
                public void cameraChanged() {
                    canvas.display();
                }
            });
            this.arcball = new Arcball1DOFAdapter(this.shared.camera);
            this.shared.textrenderer = new TextRenderer(new Font("SansSerif", 1, 36));
            this.switchState(this.state);
        }

        void switchState(State newstate) {
            this.canvas.removeMouseListener(this.menuStarter);
            this.canvas.removeMouseListener(this.menuOverlay);
            this.canvas.removeMouseListener(this.arcball);
            this.canvas.removeMouseMotionListener(this.arcball);
            this.canvas.removeMouseWheelListener(this.arcball);
            switch (newstate) {
                case EXPLORE: {
                    this.canvas.addMouseListener(this.menuStarter);
                    this.canvas.addMouseListener(this.arcball);
                    this.canvas.addMouseMotionListener(this.arcball);
                    this.canvas.addMouseWheelListener(this.arcball);
                    break;
                }
                case MENU: {
                    this.canvas.addMouseListener(this.menuOverlay);
                    break;
                }
            }
            if (this.state != newstate) {
                this.state = newstate;
                this.canvas.repaint();
            }
        }

        @Override
        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            this.shared.camera.setRatio((double)width / (double)height);
            this.messageOverlay.setSize(width, height);
            this.menuOverlay.setSize(width, height);
        }

        @Override
        public void display(GLAutoDrawable drawable) {
            GL2 gl = drawable.getGL().getGL2();
            gl.glClear(16384);
            if (this.shared.layout != null) {
                int res = this.prenderer.prepare(gl);
                if (res == 1) {
                    this.canvas.repaint();
                }
                if (res == 2) {
                    this.messageOverlay.setMessage("Texture rendering completed.");
                    this.switchState(State.EXPLORE);
                }
            }
            this.shared.camera.apply(gl);
            if (this.shared.layout != null) {
                this.prenderer.drawParallelPlot(drawable, gl);
            }
            if (State.MENU.equals((Object)this.state)) {
                this.menuOverlay.render(gl);
            }
            if (State.PREPARATION.equals((Object)this.state)) {
                this.messageOverlay.render(gl);
            }
        }

        protected void setLayout(final Layout newlayout) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    shared.layout = newlayout;
                    prenderer.forgetTextures(null);
                    messageOverlay.setMessage("Rendering Textures.");
                    canvas.repaint();
                }
            });
        }

        @Override
        public void dispose(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            this.prenderer.forgetTextures(gl);
        }

        protected static class Shared<O> {
            int dim;
            Relation<? extends O> rel;
            String[] labels;
            ProjectionParallel proj;
            StylingPolicy stylepol;
            StyleLibrary stylelib;
            Layout layout;
            Settings<O> settings;
            Simple1DOFCamera camera;
            TextRenderer textrenderer;
            double[] mat;

            protected Shared() {
            }
        }

        protected static enum State {
            PREPARATION,
            EXPLORE,
            MENU;

        }
    }

    public static class Settings<O> {
        public DependenceMeasure sim;
        public Layouter3DPC<? super O> layout;
        public float linewidth = 2.0f;
        public int texwidth = 256;
        public int texheight = 1024;
        public int mipmaps = 1;
    }
}

