/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.OpenGL3DParallelCoordinates;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layout;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import net.jafama.FastMath;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class Parallel3DRenderer<O extends NumberVector> {
    private static final Logging LOG = Logging.getLogger(Parallel3DRenderer.class);
    OpenGL3DParallelCoordinates.Instance.Shared<O> shared;
    private int[] textures;
    private int completedTextures = 0;
    private int[] dindex;
    float[] colors;
    DoubleIntPair[] axes;
    int[] vbi = new int[]{-1};
    int[] frameBufferID = new int[]{-1};

    protected Parallel3DRenderer(OpenGL3DParallelCoordinates.Instance.Shared<O> shared) {
        this.shared = shared;
        this.dindex = new int[shared.dim];
        this.axes = new DoubleIntPair[shared.dim];
        for (int i = 0; i < shared.dim; ++i) {
            this.axes[i] = new DoubleIntPair(0.0, 0);
        }
    }

    protected int prepare(GL2 gl) {
        if (this.completedTextures < 0) {
            if (this.textures != null) {
                gl.glDeleteTextures(this.textures.length, this.textures, 0);
                this.textures = null;
            }
            this.completedTextures = 0;
        }
        if (this.completedTextures >= this.shared.layout.edges.size()) {
            return 0;
        }
        if (!LOG.isDebugging()) {
            this.renderTexture(gl, this.completedTextures);
        } else {
            long start = System.nanoTime();
            this.renderTexture(gl, this.completedTextures);
            long end = System.nanoTime();
            LOG.debug("Time to render texture: " + (double)(end - start) / 1000000.0 + " ms.");
        }
        return this.completedTextures < this.shared.layout.edges.size() ? 1 : 2;
    }

    protected void drawParallelPlot(GLAutoDrawable drawable, GL2 gl) {
        this.sortAxes();
        IntIntPair[] edgesort = this.sortEdges(this.dindex);
        if (this.textures != null) {
            gl.glShadeModel(7424);
            gl.glLineWidth(this.shared.settings.linewidth);
            gl.glBegin(1);
            gl.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
            for (Layout.Edge edge : this.shared.layout.edges) {
                Layout.Node n1 = this.shared.layout.getNode(edge.dim1);
                IntIntPair[] n2 = this.shared.layout.getNode(edge.dim2);
                gl.glVertex3d(n1.getX(), n1.getY(), 0.0);
                gl.glVertex3d(n2.getX(), n2.getY(), 0.0);
            }
            gl.glEnd();
            for (int i = 0; i < this.shared.dim; ++i) {
                int n = this.axes[i].second;
                Layout.Node node1 = this.shared.layout.getNode(n);
                for (IntIntPair pair : edgesort) {
                    if (pair.second >= this.completedTextures || pair.first >= i) continue;
                    Layout.Edge edge = this.shared.layout.edges.get(pair.second);
                    if (edge.dim1 != n && edge.dim2 != n) continue;
                    int od = this.axes[pair.first].second;
                    gl.glEnable(3553);
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    Layout.Node node2 = this.shared.layout.getNode(od);
                    gl.glBindTexture(3553, this.textures[pair.second]);
                    gl.glBegin(7);
                    gl.glTexCoord2d(edge.dim1 == n ? 0.0 : 1.0, 0.0);
                    gl.glVertex3d(node1.getX(), node1.getY(), 0.0);
                    gl.glTexCoord2d(edge.dim1 == n ? 0.0 : 1.0, 1.0);
                    gl.glVertex3d(node1.getX(), node1.getY(), 1.0);
                    gl.glTexCoord2d(edge.dim1 != n ? 0.0 : 1.0, 1.0);
                    gl.glVertex3d(node2.getX(), node2.getY(), 1.0);
                    gl.glTexCoord2d(edge.dim1 != n ? 0.0 : 1.0, 0.0);
                    gl.glVertex3d(node2.getX(), node2.getY(), 0.0);
                    gl.glEnd();
                    gl.glDisable(3553);
                }
                gl.glLineWidth(this.shared.settings.linewidth);
                gl.glBegin(1);
                gl.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
                gl.glVertex3d(node1.getX(), node1.getY(), 0.0);
                gl.glVertex3d(node1.getX(), node1.getY(), 1.0);
                gl.glEnd();
                LinearScale scale = this.shared.proj.getAxisScale(n);
                gl.glPointSize(this.shared.settings.linewidth * 2.0f);
                gl.glBegin(0);
                for (double tick = scale.getMin(); tick <= scale.getMax() + scale.getRes() / 10.0; tick += scale.getRes()) {
                    gl.glVertex3d(node1.getX(), node1.getY(), scale.getScaled(tick));
                }
                gl.glEnd();
            }
        }
        this.renderLabels(gl, edgesort);
    }

    void renderTexture(GL2 gl, int edge) {
        assert (edge == this.completedTextures);
        this.prepareColors(this.shared.stylepol);
        if (this.vbi[0] < 0) {
            gl.glGenBuffers(1, this.vbi, 0);
            gl.glBindBuffer(34962, this.vbi[0]);
            gl.glBufferData(34962, this.shared.rel.size() * 2 * 5 * 4, null, 35048);
        } else {
            gl.glBindBuffer(34962, this.vbi[0]);
        }
        if (this.textures == null) {
            this.textures = new int[this.shared.layout.edges.size()];
            gl.glGenTextures(this.textures.length, this.textures, 0);
        }
        if (this.frameBufferID[0] < 0) {
            gl.glGenFramebuffers(1, this.frameBufferID, 0);
        }
        gl.glPushAttrib(264192);
        gl.glPushMatrix();
        gl.glBindFramebuffer(36160, this.frameBufferID[0]);
        Layout.Edge e = this.shared.layout.edges.get(edge);
        gl.glBindTexture(3553, this.textures[edge]);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexEnvi(8960, 8704, 8448);
        gl.glTexImage2D(3553, 0, 32859, this.shared.settings.texwidth, this.shared.settings.texheight, 0, 6408, 5126, null);
        gl.glViewport(0, 0, this.shared.settings.texwidth, this.shared.settings.texheight);
        gl.glFramebufferTexture2D(36160, 36064, 3553, this.textures[edge], 0);
        if (gl.glCheckFramebufferStatus(36160) != 36053) {
            LOG.warning("glCheckFramebufferStatus: " + gl.glCheckFramebufferStatus(36160));
        }
        gl.glDisable(2896);
        gl.glDisable(2884);
        gl.glDisable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, 1.0, 0.0, 100.0, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        gl.glClear(16384);
        gl.glShadeModel(7425);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glEnable(2848);
        gl.glLineWidth(this.shared.settings.linewidth);
        if (this.shared.stylepol instanceof ClassStylingPolicy) {
            ClassStylingPolicy csp = (ClassStylingPolicy)this.shared.stylepol;
            int mincolor = csp.getMinStyle();
            ByteBuffer vbytebuffer = gl.glMapBuffer(34962, 35001);
            FloatBuffer vertices = vbytebuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
            int p = 0;
            DBIDIter it = this.shared.rel.iterDBIDs();
            while (it.valid()) {
                NumberVector vec = (NumberVector)this.shared.rel.get(it);
                int c = (csp.getStyleForDBID(it) - mincolor) * 3;
                float v1 = (float)this.shared.proj.fastProjectDataToRenderSpace(vec.doubleValue(e.dim1), e.dim1);
                float v2 = (float)this.shared.proj.fastProjectDataToRenderSpace(vec.doubleValue(e.dim2), e.dim2);
                vertices.put(0.0f);
                vertices.put(v1);
                vertices.put(this.colors[c]);
                vertices.put(this.colors[c + 1]);
                vertices.put(this.colors[c + 2]);
                vertices.put(1.0f);
                vertices.put(v2);
                vertices.put(this.colors[c]);
                vertices.put(this.colors[c + 1]);
                vertices.put(this.colors[c + 2]);
                it.advance();
                p += 2;
            }
            vertices.flip();
            gl.glUnmapBuffer(34962);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glBindBuffer(34962, this.vbi[0]);
            gl.glVertexPointer(2, 5126, 20, 0L);
            gl.glEnableClientState(32884);
            gl.glColorPointer(3, 5126, 20, 8L);
            gl.glEnableClientState(32886);
            gl.glDrawArrays(1, 0, p);
            gl.glDisableClientState(32886);
            gl.glDisableClientState(32884);
        } else {
            ByteBuffer vbytebuffer = gl.glMapBuffer(34962, 35001);
            FloatBuffer vertices = vbytebuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
            int p = 0;
            DBIDIter it = this.shared.rel.iterDBIDs();
            while (it.valid()) {
                NumberVector vec = (NumberVector)this.shared.rel.get(it);
                float v1 = (float)this.shared.proj.fastProjectDataToRenderSpace(vec.doubleValue(e.dim1), e.dim1);
                float v2 = (float)this.shared.proj.fastProjectDataToRenderSpace(vec.doubleValue(e.dim2), e.dim2);
                vertices.put(0.0f);
                vertices.put(v1);
                vertices.put(1.0f);
                vertices.put(v2);
                it.advance();
                p += 2;
            }
            vertices.flip();
            gl.glUnmapBuffer(34962);
            gl.glBindBuffer(34962, this.vbi[0]);
            gl.glEnableClientState(32884);
            gl.glVertexPointer(2, 5126, 0, 0L);
            gl.glColor3f(this.colors[0], this.colors[1], this.colors[2]);
            gl.glDrawArrays(1, 0, p);
            gl.glDisableClientState(32884);
        }
        if (this.shared.settings.mipmaps > 0) {
            gl.glTexParameteri(3553, 33084, 0);
            gl.glTexParameteri(3553, 33085, this.shared.settings.mipmaps);
            gl.glTexParameteri(3553, 10240, 9729);
            gl.glTexParameteri(3553, 10241, 9987);
            gl.glHint(33170, 4354);
            gl.glGenerateMipmap(3553);
        }
        gl.glBindTexture(3553, 0);
        if (!gl.glIsTexture(this.textures[0])) {
            LOG.warning("Generating texture failed!");
        }
        gl.glBindFramebuffer(36160, 0);
        gl.glPopMatrix();
        gl.glPopAttrib();
        ++this.completedTextures;
        if (this.completedTextures == this.shared.layout.edges.size()) {
            gl.glDeleteBuffers(this.vbi.length, this.vbi, 0);
            this.vbi[0] = -1;
            gl.glDeleteFramebuffers(1, this.frameBufferID, 0);
            this.frameBufferID[0] = -1;
        }
    }

    private void prepareColors(StylingPolicy sp) {
        if (this.colors == null) {
            ColorLibrary cols = this.shared.stylelib.getColorSet("plot");
            if (sp instanceof ClassStylingPolicy) {
                ClassStylingPolicy csp = (ClassStylingPolicy)sp;
                int maxStyle = csp.getMaxStyle();
                this.colors = new float[maxStyle * 3];
                int c = 0;
                for (int s = csp.getMinStyle(); s < maxStyle; ++s) {
                    Color col = SVGUtil.stringToColor(cols.getColor(s));
                    this.colors[c + 0] = (float)col.getRed() / 255.0f;
                    this.colors[c + 1] = (float)col.getGreen() / 255.0f;
                    this.colors[c + 2] = (float)col.getBlue() / 255.0f;
                    c += 3;
                }
            } else {
                this.colors = new float[]{0.0f, 0.0f, 0.0f};
            }
        }
    }

    protected void forgetTextures(GL gl) {
        if (gl == null) {
            this.completedTextures = -1;
        } else {
            if (this.textures != null) {
                gl.glDeleteTextures(this.textures.length, this.textures, 0);
                this.textures = null;
            }
            this.completedTextures = 0;
        }
    }

    private void sortAxes() {
        for (int d = 0; d < this.shared.dim; ++d) {
            double dist = this.shared.camera.squaredDistanceFromCamera(this.shared.layout.getNode(d).getX(), this.shared.layout.getNode(d).getY());
            this.axes[d].first = -dist;
            this.axes[d].second = d;
        }
        Arrays.sort(this.axes);
        for (int i = 0; i < this.shared.dim; ++i) {
            this.dindex[this.axes[i].second] = i;
        }
    }

    private IntIntPair[] sortEdges(int[] dindex) {
        Object[] edgesort = new IntIntPair[this.shared.layout.edges.size()];
        int e = 0;
        for (Layout.Edge edge : this.shared.layout.edges) {
            int i1 = dindex[edge.dim1];
            int i2 = dindex[edge.dim2];
            edgesort[e] = new IntIntPair(Math.min(i1, i2), e);
            ++e;
        }
        Arrays.sort(edgesort);
        return edgesort;
    }

    private void renderLabels(GL2 gl, IntIntPair[] edgesort) {
        this.shared.textrenderer.begin3DRendering();
        gl.glRotatef((float)MathUtil.rad2deg(this.shared.camera.getRotationZ()), 0.0f, 0.0f, 1.0f);
        gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        double cos = FastMath.cos(this.shared.camera.getRotationZ());
        double sin = FastMath.sin(this.shared.camera.getRotationZ());
        this.shared.textrenderer.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        float defaultscale = 0.01f / (float)FastMath.sqrt(this.shared.dim);
        float targetwidth = 0.2f;
        float minratio = 8.0f;
        for (int i = 0; i < this.shared.dim; ++i) {
            if (this.shared.labels[i] == null) continue;
            Rectangle2D b = this.shared.textrenderer.getBounds(this.shared.labels[i]);
            float scale = defaultscale;
            if (Math.max(b.getWidth(), b.getHeight() * 8.0) * (double)scale > (double)0.2f) {
                scale = 0.2f / (float)Math.max(b.getWidth(), b.getHeight() * 8.0);
            }
            float w = (float)b.getWidth() * scale;
            float x = (float)(cos * this.shared.layout.getNode(i).getX() + sin * this.shared.layout.getNode(i).getY());
            float y = (float)(-sin * this.shared.layout.getNode(i).getX() + cos * this.shared.layout.getNode(i).getY());
            this.shared.textrenderer.draw3D(this.shared.labels[i], x - w * 0.5f, 1.01f, -y, scale);
        }
        this.shared.textrenderer.end3DRendering();
    }
}

