/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.layout;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.CorrelationDependenceMeasure;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layout;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.SimilarityBasedLayouter3DPC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLayout3DPC<N extends Layout.Node>
implements SimilarityBasedLayouter3DPC {
    DependenceMeasure sim = CorrelationDependenceMeasure.STATIC;

    public AbstractLayout3DPC(DependenceMeasure sim) {
        this.sim = sim;
    }

    @Override
    public DependenceMeasure getSimilarity() {
        return this.sim;
    }

    @Override
    public Layout layout(Relation<? extends NumberVector> rel) {
        return this.layout(RelationUtil.dimensionality(rel), AbstractLayout3DPC.computeSimilarityMatrix(this.sim, rel));
    }

    public static double[] computeSimilarityMatrix(DependenceMeasure sim, Relation<? extends NumberVector> rel) {
        int dim = RelationUtil.dimensionality(rel);
        double[][] data = new double[dim][rel.size()];
        int r = 0;
        DBIDIter it = rel.iterDBIDs();
        while (it.valid()) {
            NumberVector v = rel.get(it);
            for (int d = 0; d < dim; ++d) {
                data[d][r] = v.doubleValue(d);
            }
            it.advance();
            ++r;
        }
        return sim.dependence(DoubleArrayAdapter.STATIC, Arrays.asList(data));
    }

    @Override
    public abstract Layout layout(int var1, double[] var2);

    protected N buildSpanningTree(int dim, double[] mat, Layout layout) {
        assert (layout.edges == null || layout.edges.size() == 0);
        int[] iedges = PrimsMinimumSpanningTree.processDense(mat, new LowerTriangularAdapter(dim));
        int root = AbstractLayout3DPC.findOptimalRoot(iedges);
        ArrayList<? extends Layout.Edge> edges = new ArrayList<Layout.Edge>(iedges.length >> 1);
        for (int i = 1; i < iedges.length; i += 2) {
            edges.add(new Layout.Edge(iedges[i - 1], iedges[i]));
        }
        layout.edges = edges;
        ArrayList<? extends Layout.Node> nodes = new ArrayList<Layout.Node>(dim);
        for (int i = 0; i < dim; ++i) {
            nodes.add(null);
        }
        layout.nodes = nodes;
        Layout.Node rootnode = this.buildTree(iedges, root, -1, nodes);
        return (N)rootnode;
    }

    abstract N makeNode(int var1, List<N> var2);

    protected N buildTree(int[] msg, int cur, int parent, ArrayList<N> nodes) {
        int c = 0;
        for (int i = 1; i < msg.length; i += 2) {
            if ((msg[i - 1] != cur || msg[i] == parent) && (msg[i] != cur || msg[i - 1] == parent)) continue;
            ++c;
        }
        List children = Collections.emptyList();
        if (c > 0) {
            children = new ArrayList(c);
            for (int i = 1; i < msg.length; i += 2) {
                if (msg[i - 1] == cur && msg[i] != parent) {
                    children.add(this.buildTree(msg, msg[i], cur, nodes));
                    continue;
                }
                if (msg[i] != cur || msg[i - 1] == parent) continue;
                children.add(this.buildTree(msg, msg[i - 1], cur, nodes));
            }
        }
        Object node = this.makeNode(cur, children);
        nodes.set(cur, node);
        return (N)node;
    }

    protected int maxDepth(Layout.Node node) {
        int depth = 0;
        for (int i = 0; i < node.numChildren(); ++i) {
            depth = Math.max(depth, this.maxDepth(node.getChild(i)));
        }
        return depth + 1;
    }

    public static int findOptimalRoot(int[] msg) {
        int size = (msg.length >> 1) + 1;
        int[] depth = new int[size];
        int[] missing = new int[size];
        int root = -1;
        for (int i = 1; i < size; ++i) {
            boolean active = false;
            for (int e = 1; e < msg.length; e += 2) {
                if (depth[msg[e - 1]] == 0) {
                    int n = msg[e];
                    missing[n] = missing[n] + 1;
                }
                if (depth[msg[e]] != 0) continue;
                int n = msg[e - 1];
                missing[n] = missing[n] + 1;
            }
            for (int n = 0; n < size; ++n) {
                if (depth[n] != 0 || missing[n] > 1) continue;
                depth[n] = i;
                root = n;
                active = true;
            }
            if (!active) break;
            Arrays.fill(missing, 0);
        }
        return root;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        DependenceMeasure sim;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter simP = new ObjectParameter(SimilarityBasedLayouter3DPC.SIM_ID, (Class<?>)DependenceMeasure.class, CorrelationDependenceMeasure.class);
            if (config.grab(simP)) {
                this.sim = (DependenceMeasure)simP.instantiateClass(config);
            }
        }
    }

    public static class AbstractNode<N extends AbstractNode<N>>
    implements Layout.Node {
        public int dim;
        public double x;
        public double y;
        public List<N> children;

        public AbstractNode(int dim, List<N> children) {
            this.dim = dim;
            this.children = children;
        }

        @Override
        public int getDim() {
            return this.dim;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        public N getChild(int off) {
            return (N)((AbstractNode)this.children.get(off));
        }

        @Override
        public int numChildren() {
            return this.children.size();
        }
    }

    private static class LowerTriangularAdapter
    implements PrimsMinimumSpanningTree.Adapter<double[]> {
        int dim;

        public LowerTriangularAdapter(int dim) {
            this.dim = dim;
        }

        @Override
        public double distance(double[] data, int i, int j) {
            return i == j ? 0.0 : (j < i ? this.distance(data, j, i) : -Math.abs(data[(j * (j - 1) >> 1) + i]));
        }

        @Override
        public int size(double[] data) {
            return this.dim;
        }
    }
}

