/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.layout;

import de.lmu.ifi.dbs.elki.math.linearalgebra.SingularValueDecomposition;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.AbstractLayout3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layout;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class MultidimensionalScalingMSTLayout3DPC
extends AbstractLayout3DPC<Node> {
    public MultidimensionalScalingMSTLayout3DPC(DependenceMeasure sim) {
        super(sim);
    }

    @Override
    Node makeNode(int dim, List<Node> children) {
        return new Node(dim, children);
    }

    @Override
    public Layout layout(int dim, double[] mat) {
        Node n;
        int i;
        double max = 0.0;
        for (double v : mat) {
            v = v > 0.0 ? v : -v;
            max = v > max ? v : max;
        }
        double[] means = new double[dim];
        double mean = 0.0;
        int o = 0;
        for (int y = 1; y < dim; ++y) {
            int x = 0;
            while (x < y) {
                double v = max - Math.abs(mat[o]);
                v = -0.5 * FastMath.sqrt(v);
                int n2 = x++;
                means[n2] = means[n2] + v;
                int n3 = y;
                means[n3] = means[n3] + v;
                mean += 2.0 * v;
                ++o;
            }
        }
        int i2 = 0;
        while (i2 < dim) {
            int n4 = i2++;
            means[n4] = means[n4] / (double)dim;
        }
        mean /= (double)(dim * dim);
        double[][] d = new double[dim][dim];
        int o2 = 0;
        for (int y = 1; y < dim; ++y) {
            d[y][y] = -2.0 * means[y] + mean;
            int x = 0;
            while (x < y) {
                double v = max - Math.abs(mat[o2]);
                double d2 = v = -0.5 * FastMath.sqrt(v) - means[x] - means[y] + mean;
                d[y][x] = d2;
                d[x][y] = d2;
                ++x;
                ++o2;
            }
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(d);
        double[][] u = svd.getU();
        double[] lambda = svd.getSingularValues();
        lambda[0] = FastMath.sqrt(Math.abs(lambda[0]));
        lambda[1] = FastMath.sqrt(Math.abs(lambda[1]));
        Layout l = new Layout();
        this.buildSpanningTree(dim, mat, l);
        double maxabs = 0.0;
        for (i = 0; i < dim; ++i) {
            n = (Node)l.getNode(i);
            n.x = u[i][0] * lambda[0];
            n.y = u[i][1] * lambda[1];
            double v = n.x * n.x + n.y * n.y;
            if (!(v > maxabs)) continue;
            maxabs = v;
        }
        maxabs = 1.0 / FastMath.sqrt(maxabs);
        for (i = 0; i < dim; ++i) {
            n = (Node)l.getNode(i);
            n.x *= maxabs;
            n.y *= maxabs;
        }
        return l;
    }

    public static class Parameterizer
    extends AbstractLayout3DPC.Parameterizer {
        @Override
        protected MultidimensionalScalingMSTLayout3DPC makeInstance() {
            return new MultidimensionalScalingMSTLayout3DPC(this.sim);
        }
    }

    public static class Node
    extends AbstractLayout3DPC.AbstractNode<Node> {
        public Node(int dim, List<Node> children) {
            super(dim, children);
        }
    }
}

