/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.layout;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.AbstractLayout3DPC;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.layout.Layout;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class SimpleCircularMSTLayout3DPC
extends AbstractLayout3DPC<Node> {
    public SimpleCircularMSTLayout3DPC(DependenceMeasure sim) {
        super(sim);
    }

    @Override
    public Layout layout(int dim, double[] mat) {
        Layout l = new Layout();
        Node rootnode = (Node)this.buildSpanningTree(dim, mat, l);
        int maxdepth = this.maxDepth(rootnode);
        this.computeWeights(rootnode);
        SimpleCircularMSTLayout3DPC.computePositions(rootnode, 0, 0.0, Math.PI * 2, maxdepth);
        return l;
    }

    private void computeWeights(Node node) {
        int wsum = 0;
        for (Node child : node.children) {
            this.computeWeights(child);
            wsum += child.weight;
        }
        node.weight = Math.max(1, wsum);
    }

    public static void computePositions(Node node, int depth, double aoff, double awid, int maxdepth) {
        double r = (double)depth / ((double)maxdepth - 1.0);
        node.x = FastMath.sin(aoff + awid * 0.5) * r;
        node.y = FastMath.cos(aoff + awid * 0.5) * r;
        double cpos = aoff;
        double cwid = awid / (double)node.weight;
        for (Node c : node.children) {
            SimpleCircularMSTLayout3DPC.computePositions(c, depth + 1, cpos, cwid * (double)c.weight, maxdepth);
            cpos += cwid * (double)c.weight;
        }
    }

    @Override
    Node makeNode(int dim, List<Node> children) {
        return new Node(dim, children);
    }

    public static class Parameterizer
    extends AbstractLayout3DPC.Parameterizer {
        @Override
        protected SimpleCircularMSTLayout3DPC makeInstance() {
            return new SimpleCircularMSTLayout3DPC(this.sim);
        }
    }

    public static class Node
    extends AbstractLayout3DPC.AbstractNode<Node> {
        public int weight;

        public Node(int dim, List<Node> children) {
            super(dim, children);
        }
    }
}

