/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.util;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.Simple1DOFCamera;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.media.opengl.GL2;
import javax.swing.event.MouseInputAdapter;
import net.jafama.FastMath;

public class Arcball1DOFAdapter
extends MouseInputAdapter {
    private static final boolean DEBUG = false;
    private final Simple1DOFCamera camera;
    private double[] startvec = new double[3];
    private double[] endvec = new double[3];
    private double[] near = new double[3];
    private double[] far = new double[3];
    double startangle;
    private Simple1DOFCamera startcamera;

    public Arcball1DOFAdapter(Simple1DOFCamera camera) {
        this.camera = camera;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int s;
        double distance = this.camera.getDistance();
        for (s = e.getWheelRotation(); s >= 1; --s) {
            distance += 0.1;
        }
        while (s <= -1) {
            if (distance > 0.15) {
                distance -= 0.1;
            }
            ++s;
        }
        this.camera.setDistance(distance);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startcamera = new Simple1DOFCamera(this.camera);
        Point startPoint = e.getPoint();
        this.mapMouseToPlane(this.startcamera, startPoint, this.startvec);
        this.startangle = FastMath.atan2(this.startvec[1], this.startvec[0]);
    }

    private void mapMouseToPlane(Simple1DOFCamera camera, Point point2d, double[] vec) {
        camera.unproject(point2d.x, point2d.y, -100.0, this.far);
        camera.unproject(point2d.x, point2d.y, 1.0, this.near);
        VMath.minusEquals(this.far, this.near);
        if (this.near[2] < 0.0 || this.near[2] > 0.0) {
            double a = this.far[2] / this.near[2];
            vec[0] = this.far[0] - a * this.near[0];
            vec[1] = this.far[1] - a * this.near[1];
            vec[2] = 0.0;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mapMouseToPlane(this.startcamera, e.getPoint(), this.endvec);
        double upangle = FastMath.atan2(this.endvec[1], this.endvec[0]);
        this.camera.setRotationZ(this.startcamera.getRotationZ() + (upangle - this.startangle));
    }

    public void debugRender(GL2 gl) {
    }
}

