/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.util;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import net.jafama.FastMath;

public class Simple1DOFCamera {
    private double rotationZ = 0.0;
    private double distance = 3.0;
    private double height = 1.5;
    private double ratio = 1.0;
    private int[] viewp = new int[4];
    private double[] modelview = new double[16];
    private double[] projection = new double[16];
    private GLU glu;
    private double cosZ;
    private double sinZ;
    ArrayList<CameraListener> listeners;

    public Simple1DOFCamera(GLU glu) {
        this.glu = glu;
        this.viewp = new int[4];
        this.modelview = new double[16];
        this.projection = new double[16];
        this.rotationZ = 0.0;
        this.cosZ = 1.0;
        this.sinZ = 0.0;
        this.listeners = new ArrayList(5);
    }

    public Simple1DOFCamera(Simple1DOFCamera other) {
        this.rotationZ = other.rotationZ;
        this.distance = other.distance;
        this.height = other.height;
        this.ratio = other.ratio;
        this.viewp = (int[])other.viewp.clone();
        this.modelview = (double[])other.modelview.clone();
        this.projection = (double[])other.projection.clone();
        this.glu = other.glu;
        this.listeners = null;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
        this.fireCameraChangedEvent();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        this.fireCameraChangedEvent();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRotationZ() {
        return this.rotationZ;
    }

    public void setRotationZ(double rotationZ) {
        this.rotationZ = rotationZ;
        this.cosZ = FastMath.cos(rotationZ);
        this.sinZ = FastMath.sin(rotationZ);
        this.fireCameraChangedEvent();
    }

    public void apply(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(35.0, this.ratio, 1.0, 1000.0);
        this.glu.gluLookAt(this.distance * this.sinZ, this.distance * -this.cosZ, this.height, 0.0, 0.0, 0.5, 0.0, 0.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glGetIntegerv(2978, this.viewp, 0);
        gl.glGetDoublev(2982, this.modelview, 0);
        gl.glGetDoublev(2983, this.projection, 0);
    }

    public double[] unproject(double x, double y, double z) {
        double[] out = new double[3];
        this.unproject(x, y, z, out);
        return out;
    }

    public void unproject(double x, double y, double z, double[] out) {
        this.glu.gluUnProject(x, y, z, this.modelview, 0, this.projection, 0, this.viewp, 0, out, 0);
    }

    public void project(double x, double y, double z, double[] out) {
        this.glu.gluProject(x, y, z, this.modelview, 0, this.projection, 0, this.viewp, 0, out, 0);
    }

    public double squaredDistanceFromCamera(double x, double y) {
        double dx = this.distance * this.sinZ - x;
        double dy = this.distance * -this.cosZ - y;
        return dx * dx + dy * dy;
    }

    public double squaredDistanceFromCamera(double x, double y, double z) {
        double dx = this.distance * this.sinZ - x;
        double dy = this.distance * -this.cosZ - y;
        double dz = this.height - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void addCameraListener(CameraListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listeners.add(lis);
    }

    public void removeCameraListener(CameraListener lis) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(lis);
    }

    protected void fireCameraChangedEvent() {
        if (this.listeners != null) {
            for (CameraListener list : this.listeners) {
                list.cameraChanged();
            }
        }
    }

    @FunctionalInterface
    public static interface CameraListener {
        public void cameraChanged();
    }
}

