/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.parallel3d.util;

import com.jogamp.opengl.util.awt.TextRenderer;
import de.lmu.ifi.dbs.elki.visualization.parallel3d.util.AbstractSimpleOverlay;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.opengl.GL2;

public abstract class SimpleMenuOverlay
extends AbstractSimpleOverlay
implements MouseListener {
    TextRenderer renderer;
    private ArrayList<String> options = new ArrayList();
    int fontsize = 18;

    public SimpleMenuOverlay() {
        this.renderer = new TextRenderer(new Font("SansSerif", 0, this.fontsize));
    }

    @Override
    void renderContents(GL2 gl) {
        int numopt = this.getOptions().size();
        double maxwidth = 0.0;
        Rectangle2D[] bounds = new Rectangle2D[numopt];
        for (int i = 0; i < numopt; ++i) {
            String string = this.getOptions().get(i);
            if (string == null) continue;
            bounds[i] = this.renderer.getBounds(string);
            maxwidth = Math.max(bounds[i].getWidth(), maxwidth);
        }
        double padding = 0.5 * (double)this.fontsize;
        double margin = padding * 0.3;
        float bx1 = (float)(0.5 * ((double)this.width - maxwidth - padding));
        float bx2 = (float)(0.5 * ((double)this.width + maxwidth + padding));
        double totalheight = (double)(numopt * this.fontsize) + (double)(numopt - 1) * padding;
        gl.glBegin(7);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.75f);
        for (int i = 0; i < numopt; ++i) {
            if (bounds[numopt - i - 1] == null) continue;
            double pos = ((double)this.height - totalheight) * 0.5 + (double)(this.fontsize * i) + padding * (double)i;
            gl.glVertex2f(bx1, (float)(pos - margin));
            gl.glVertex2f(bx1, (float)(pos + (double)this.fontsize + margin));
            gl.glVertex2f(bx2, (float)(pos + (double)this.fontsize + margin));
            gl.glVertex2f(bx2, (float)(pos - margin));
        }
        gl.glEnd();
        this.renderer.beginRendering(this.width, this.height);
        this.renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (int j = 0; j < numopt; ++j) {
            if (bounds[j] == null) continue;
            int i = numopt - j - 1;
            double pos = ((double)this.height - totalheight) * 0.5 + (double)(this.fontsize * i) + padding * (double)i + 0.17 * (double)this.fontsize;
            this.renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.renderer.draw(this.getOptions().get(j), this.width - (int)bounds[j].getWidth() >> 1, (int)pos);
        }
        this.renderer.endRendering();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.menuItemClicked(-1);
        }
        if (e.getButton() != 1) {
            return;
        }
        int mx = e.getX();
        int my = e.getY();
        int numopt = this.getOptions().size();
        double maxwidth = 0.0;
        for (int i = 0; i < numopt; ++i) {
            String string = this.getOptions().get(i);
            if (string == null) continue;
            Rectangle2D bounds = this.renderer.getBounds(string);
            maxwidth = Math.max(bounds.getWidth(), maxwidth);
        }
        double padding = 0.5 * (double)this.fontsize;
        double margin = padding * 0.3;
        float bx1 = (float)(0.5 * ((double)this.width - maxwidth - padding));
        float bx2 = (float)(0.5 * ((double)this.width + maxwidth + padding));
        if ((float)mx < bx1 || (float)mx > bx2) {
            this.menuItemClicked(-1);
            return;
        }
        double totalheight = (double)(numopt * this.fontsize) + (double)(numopt - 1) * padding;
        for (int i = 0; i < numopt; ++i) {
            double pos = ((double)this.height - totalheight) * 0.5 + (double)(this.fontsize * i) + padding * (double)i;
            if ((double)my < pos - margin) {
                this.menuItemClicked(-1);
                return;
            }
            if (!((double)my < pos + (double)this.fontsize + margin)) continue;
            this.menuItemClicked(i);
            return;
        }
        this.menuItemClicked(-1);
    }

    public abstract void menuItemClicked(int var1);

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public ArrayList<String> getOptions() {
        return this.options;
    }

    public void setOptions(ArrayList<String> options) {
        this.options = options;
    }
}

