/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.FullProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public abstract class AbstractFullProjection
extends AbstractProjection
implements FullProjection {
    public AbstractFullProjection(Projector p, LinearScale[] scales) {
        super(p, scales);
    }

    @Override
    public double[] projectDataToScaledSpace(NumberVector data) {
        int dim = data.getDimensionality();
        double[] vec = new double[dim];
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getScaled(data.doubleValue(d));
        }
        return vec;
    }

    @Override
    public double[] projectDataToScaledSpace(double[] data) {
        int dim = data.length;
        double[] dst = new double[dim];
        for (int d = 0; d < dim; ++d) {
            dst[d] = this.scales[d].getScaled(data[d]);
        }
        return dst;
    }

    @Override
    public double[] projectRelativeDataToScaledSpace(NumberVector data) {
        int dim = data.getDimensionality();
        double[] vec = new double[dim];
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getRelativeScaled(data.doubleValue(d));
        }
        return vec;
    }

    @Override
    public double[] projectRelativeDataToScaledSpace(double[] data) {
        int dim = data.length;
        double[] dst = new double[dim];
        for (int d = 0; d < dim; ++d) {
            dst[d] = this.scales[d].getRelativeScaled(data[d]);
        }
        return dst;
    }

    @Override
    public double[] projectDataToRenderSpace(NumberVector data) {
        return this.projectScaledToRender(this.projectDataToScaledSpace(data));
    }

    @Override
    public double[] projectDataToRenderSpace(double[] data) {
        return this.projectScaledToRender(this.projectDataToScaledSpace(data));
    }

    @Override
    public double[] projectRelativeDataToRenderSpace(NumberVector data) {
        return this.projectRelativeScaledToRender(this.projectRelativeDataToScaledSpace(data));
    }

    @Override
    public double[] projectRelativeDataToRenderSpace(double[] data) {
        return this.projectRelativeScaledToRender(this.projectRelativeDataToScaledSpace(data));
    }

    @Override
    public <NV extends NumberVector> NV projectScaledToDataSpace(double[] v, NumberVector.Factory<NV> factory) {
        int dim = v.length;
        double[] vec = new double[dim];
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getUnscaled(v[d]);
        }
        return factory.newNumberVector(vec);
    }

    @Override
    public <NV extends NumberVector> NV projectRenderToDataSpace(double[] v, NumberVector.Factory<NV> prototype) {
        int dim = v.length;
        double[] vec = this.projectRenderToScaled(v);
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getUnscaled(vec[d]);
        }
        return prototype.newNumberVector(vec);
    }

    @Override
    public <NV extends NumberVector> NV projectRelativeScaledToDataSpace(double[] v, NumberVector.Factory<NV> prototype) {
        int dim = v.length;
        double[] vec = new double[dim];
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getRelativeUnscaled(v[d]);
        }
        return prototype.newNumberVector(vec);
    }

    @Override
    public <NV extends NumberVector> NV projectRelativeRenderToDataSpace(double[] v, NumberVector.Factory<NV> prototype) {
        int dim = v.length;
        double[] vec = this.projectRelativeRenderToScaled(v);
        for (int d = 0; d < dim; ++d) {
            vec[d] = this.scales[d].getRelativeUnscaled(vec[d]);
        }
        return prototype.newNumberVector(vec);
    }
}

