/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractFullProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public abstract class AbstractSimpleProjection
extends AbstractFullProjection {
    public AbstractSimpleProjection(Projector p, LinearScale[] scales) {
        super(p, scales);
    }

    @Override
    public double[] projectScaledToRender(double[] v) {
        v = this.rearrange(v);
        VMath.minusEquals(v, 0.5);
        v = this.flipSecondEquals(v);
        VMath.timesEquals(v, 100.0);
        return v;
    }

    @Override
    public double[] projectRenderToScaled(double[] v) {
        v = VMath.times(v, 0.01);
        v = this.flipSecondEquals(v);
        VMath.plusEquals(v, 0.5);
        v = this.dearrange(v);
        return v;
    }

    @Override
    public double[] projectRelativeScaledToRender(double[] v) {
        v = this.rearrange(v);
        v = this.flipSecondEquals(v);
        VMath.timesEquals(v, 100.0);
        return v;
    }

    @Override
    public double[] projectRelativeRenderToScaled(double[] v) {
        v = VMath.times(v, 0.01);
        v = this.flipSecondEquals(v);
        v = this.dearrange(v);
        return v;
    }

    protected double[] flipSecondEquals(double[] v) {
        if (v.length > 1) {
            v[1] = v[1] * -1.0;
        }
        return v;
    }

    protected abstract double[] rearrange(double[] var1);

    protected abstract double[] dearrange(double[] var1);
}

