/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractFullProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.Arrays;

public class AffineProjection
extends AbstractFullProjection
implements Projection2D {
    private AffineTransformation proj;
    private CanvasSize viewport = null;

    public AffineProjection(Projector p, LinearScale[] scales, AffineTransformation proj) {
        super(p, scales);
        this.proj = proj;
    }

    @Override
    public double[] projectScaledToRender(double[] v) {
        return this.proj.apply(v);
    }

    @Override
    public double[] projectRenderToScaled(double[] v) {
        return this.proj.applyInverse(v);
    }

    @Override
    public double[] projectRelativeScaledToRender(double[] v) {
        return this.proj.applyRelative(v);
    }

    @Override
    public double[] projectRelativeRenderToScaled(double[] v) {
        return this.proj.applyRelativeInverse(v);
    }

    @Override
    public CanvasSize estimateViewport() {
        if (this.viewport == null) {
            int dim = this.proj.getDimensionality();
            DoubleMinMax minmaxx = new DoubleMinMax();
            DoubleMinMax minmaxy = new DoubleMinMax();
            double[] vec = new double[dim];
            double[] orig = this.projectScaledToRender(vec);
            minmaxx.put(orig[0]);
            minmaxy.put(orig[1]);
            Arrays.fill(vec, 1.0);
            double[] diag = this.projectScaledToRender(vec);
            minmaxx.put(diag[0]);
            minmaxy.put(diag[1]);
            for (int d = 0; d < dim; ++d) {
                Arrays.fill(vec, 0.0);
                vec[d] = 1.0;
                double[] ax = this.projectScaledToRender(vec);
                minmaxx.put(ax[0]);
                minmaxy.put(ax[1]);
            }
            this.viewport = new CanvasSize(minmaxx.getMin(), minmaxx.getMax(), minmaxy.getMin(), minmaxy.getMax());
        }
        return this.viewport;
    }

    public static AffineTransformation axisProjection(int dim, int ax1, int ax2) {
        AffineTransformation proj = AffineTransformation.reorderAxesTransformation(dim, ax1, ax2);
        double[] trans = new double[dim];
        for (int i = 0; i < dim; ++i) {
            trans[i] = -0.5;
        }
        proj.addTranslation(trans);
        proj.addAxisReflection(2);
        proj.addScaling(100.0);
        return proj;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] data) {
        return this.fastProjectScaledToRenderSpace(this.fastProjectDataToScaledSpace(data));
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector data) {
        return this.fastProjectScaledToRenderSpace(this.fastProjectDataToScaledSpace(data));
    }

    @Override
    public double[] fastProjectDataToScaledSpace(double[] data) {
        return this.projectDataToScaledSpace(data);
    }

    @Override
    public double[] fastProjectDataToScaledSpace(NumberVector data) {
        return this.projectDataToScaledSpace(data);
    }

    @Override
    public double[] fastProjectScaledToRenderSpace(double[] vr) {
        double x = 0.0;
        double y = 0.0;
        double s = 0.0;
        double[][] matrix = this.proj.getTransformation();
        double[] colx = matrix[0];
        double[] coly = matrix[1];
        double[] cols = matrix[vr.length];
        assert (colx.length == coly.length && colx.length == cols.length && cols.length == vr.length + 1);
        for (int k = 0; k < vr.length; ++k) {
            x += colx[k] * vr[k];
            y += coly[k] * vr[k];
            s += cols[k] * vr[k];
        }
        return new double[]{(x += colx[vr.length]) / (s += cols[vr.length]), (y += coly[vr.length]) / s};
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(double[] data) {
        return this.fastProjectRelativeScaledToRenderSpace(this.projectRelativeDataToScaledSpace(data));
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(NumberVector data) {
        return this.fastProjectRelativeScaledToRenderSpace(this.projectRelativeDataToScaledSpace(data));
    }

    @Override
    public double[] fastProjectRelativeScaledToRenderSpace(double[] vr) {
        double x = 0.0;
        double y = 0.0;
        double[][] matrix = this.proj.getTransformation();
        double[] colx = matrix[0];
        double[] coly = matrix[1];
        assert (colx.length == coly.length);
        for (int k = 0; k < vr.length; ++k) {
            x += colx[k] * vr[k];
            y += coly[k] * vr[k];
        }
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectRenderToDataSpace(double x, double y) {
        double[] ret = this.fastProjectRenderToScaledSpace(x, y);
        for (int d = 0; d < this.scales.length; ++d) {
            ret[d] = this.scales[d].getUnscaled(ret[d]);
        }
        return ret;
    }

    @Override
    public double[] fastProjectRenderToScaledSpace(double x, double y) {
        double[] c = new double[this.scales.length];
        c[0] = x;
        c[1] = y;
        Arrays.fill(c, 2, this.scales.length, 0.5);
        return this.projectRenderToScaled(c);
    }

    @Override
    public long[] getVisibleDimensions2D() {
        int dim = this.proj.getDimensionality();
        long[] actDim = BitsUtil.zero(dim);
        double[] vScale = new double[dim];
        for (int d = 0; d < dim; ++d) {
            Arrays.fill(vScale, 0.0);
            vScale[d] = 1.0;
            double[] vRender = this.fastProjectScaledToRenderSpace(vScale);
            if (!(vRender[0] > 0.0) && !(vRender[0] < 0.0) && vRender[1] == 0.0) continue;
            BitsUtil.setI(actDim, d);
        }
        return actDim;
    }
}

