/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.math.MathUtil;

public class CanvasSize {
    public final double minx;
    public final double maxx;
    public final double miny;
    public final double maxy;

    public CanvasSize(double minx, double maxx, double miny, double maxy) {
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public double getDiffX() {
        return this.maxx - this.minx;
    }

    public double getDiffY() {
        return this.maxy - this.miny;
    }

    public double continueToMargin(double[] origin, double[] delta) {
        assert (delta.length == 2 && origin.length == 2);
        double factor = Double.POSITIVE_INFINITY;
        if (delta[0] > 0.0) {
            factor = Math.min(factor, (this.maxx - origin[0]) / delta[0]);
        } else if (delta[0] < 0.0) {
            factor = Math.min(factor, (origin[0] - this.minx) / -delta[0]);
        }
        if (delta[1] > 0.0) {
            factor = Math.min(factor, (this.maxy - origin[1]) / delta[1]);
        } else if (delta[1] < 0.0) {
            factor = Math.min(factor, (origin[1] - this.miny) / -delta[1]);
        }
        return factor;
    }

    public boolean clipToMargin(double[] origin, double[] target) {
        double factor2;
        double fminy;
        double deltay;
        double fmaxy;
        assert (target.length == 2 && origin.length == 2);
        if (origin[0] < this.minx && target[0] < this.minx || origin[0] > this.maxx && target[0] > this.maxx || origin[1] < this.miny && target[1] < this.miny || origin[1] > this.maxy && target[1] > this.maxy) {
            return false;
        }
        double deltax = target[0] - origin[0];
        double fmaxx = (this.maxx - origin[0]) / deltax;
        double fminx = (this.minx - origin[0]) / deltax;
        double factor1 = MathUtil.min(1.0, fmaxx > fminx ? fmaxx : fminx, (fmaxy = (this.maxy - origin[1]) / (deltay = target[1] - origin[1])) > (fminy = (this.miny - origin[1]) / deltay) ? fmaxy : fminy);
        if (factor1 <= (factor2 = MathUtil.max(0.0, fmaxx < fminx ? fmaxx : fminx, fmaxy < fminy ? fmaxy : fminy))) {
            return false;
        }
        target[0] = origin[0] + factor1 * deltax;
        target[1] = origin[1] + factor1 * deltay;
        origin[0] = origin[0] + factor2 * deltax;
        origin[1] = origin[1] + factor2 * deltay;
        return true;
    }

    public String toString() {
        return "CanvasSize[x=" + this.minx + ":" + this.maxx + ", y=" + this.miny + ":" + this.maxy + "]";
    }
}

