/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractSimpleProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection1D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class Simple1D
extends AbstractSimpleProjection
implements Projection1D {
    final int dnum;

    public Simple1D(Projector p, LinearScale[] scales, int dnum) {
        super(p, scales);
        this.dnum = dnum;
    }

    @Override
    public double fastProjectDataToRenderSpace(double[] data) {
        return (this.scales[this.dnum].getScaled(data[this.dnum]) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectDataToRenderSpace(NumberVector data) {
        return (this.scales[this.dnum].getScaled(data.doubleValue(this.dnum)) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectScaledToRender(double[] v) {
        return (v[this.dnum] - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeDataToRenderSpace(double[] data) {
        return (this.scales[this.dnum].getScaled(data[this.dnum]) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeDataToRenderSpace(NumberVector data) {
        return (data.doubleValue(this.dnum) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeScaledToRender(double[] v) {
        return v[this.dnum] * 100.0;
    }

    @Override
    protected double[] rearrange(double[] v) {
        double[] r = new double[v.length];
        r[0] = v[this.dnum];
        if (this.dnum > 0) {
            System.arraycopy(v, 0, r, 1, this.dnum);
        }
        if (this.dnum + 1 < v.length) {
            System.arraycopy(v, this.dnum + 1, r, this.dnum + 1, v.length - (this.dnum + 1));
        }
        return r;
    }

    @Override
    protected double[] dearrange(double[] v) {
        double[] r = new double[v.length];
        if (this.dnum > 0) {
            System.arraycopy(v, 1, r, 0, this.dnum);
        }
        r[this.dnum] = v[0];
        if (this.dnum + 1 < v.length) {
            System.arraycopy(v, this.dnum + 1, r, this.dnum + 1, v.length - (this.dnum + 1));
        }
        return r;
    }

    @Override
    public String getMenuName() {
        return "Axis";
    }
}

