/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractSimpleProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class Simple2D
extends AbstractSimpleProjection
implements Projection2D {
    private int dim1;
    private int dim2;

    public Simple2D(Projector p, LinearScale[] scales, int ax1, int ax2) {
        super(p, scales);
        this.dim1 = ax1;
        this.dim2 = ax2;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] data) {
        double x = (this.scales[this.dim1].getScaled(data[this.dim1]) - 0.5) * 100.0;
        double y = (this.scales[this.dim2].getScaled(data[this.dim2]) - 0.5) * -100.0;
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector data) {
        double x = (this.scales[this.dim1].getScaled(data.doubleValue(this.dim1)) - 0.5) * 100.0;
        double y = (this.scales[this.dim2].getScaled(data.doubleValue(this.dim2)) - 0.5) * -100.0;
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectDataToScaledSpace(double[] data) {
        int dim = data.length;
        double[] ds = new double[dim];
        for (int d = 0; d < dim; ++d) {
            ds[d] = this.scales[d].getScaled(data[d]);
        }
        return ds;
    }

    @Override
    public double[] fastProjectDataToScaledSpace(NumberVector data) {
        int dim = data.getDimensionality();
        double[] ds = new double[dim];
        for (int d = 0; d < dim; ++d) {
            ds[d] = this.scales[d].getScaled(data.doubleValue(d));
        }
        return ds;
    }

    @Override
    public double[] fastProjectScaledToRenderSpace(double[] v) {
        double x = (v[this.dim1] - 0.5) * 100.0;
        double y = (v[this.dim2] - 0.5) * -100.0;
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectRenderToDataSpace(double x, double y) {
        double[] ret = new double[this.scales.length];
        for (int d = 0; d < this.scales.length; ++d) {
            ret[d] = d == this.dim1 ? this.scales[d].getUnscaled(x * 0.01 + 0.5) : (d == this.dim2 ? this.scales[d].getUnscaled(y * -0.01 + 0.5) : this.scales[d].getUnscaled(0.5));
        }
        return ret;
    }

    @Override
    public double[] fastProjectRenderToScaledSpace(double x, double y) {
        double[] ret = new double[this.scales.length];
        for (int d = 0; d < this.scales.length; ++d) {
            ret[d] = d == this.dim1 ? x * 0.01 + 0.5 : (d == this.dim2 ? y * -0.01 + 0.5 : 0.5);
        }
        return ret;
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(double[] data) {
        double x = this.scales[this.dim1].getRelativeScaled(data[this.dim1]) * 100.0;
        double y = this.scales[this.dim2].getRelativeScaled(data[this.dim2]) * -100.0;
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(NumberVector data) {
        double x = this.scales[this.dim1].getRelativeScaled(data.doubleValue(this.dim1)) * 100.0;
        double y = this.scales[this.dim2].getRelativeScaled(data.doubleValue(this.dim2)) * -100.0;
        return new double[]{x, y};
    }

    @Override
    public double[] fastProjectRelativeScaledToRenderSpace(double[] vr) {
        double x = vr[this.dim1] * 100.0;
        double y = vr[this.dim2] * -100.0;
        return new double[]{x, y};
    }

    @Override
    public long[] getVisibleDimensions2D() {
        long[] actDim = new long[this.scales.length];
        BitsUtil.setI(actDim, this.dim1);
        BitsUtil.setI(actDim, this.dim2);
        return actDim;
    }

    @Override
    public CanvasSize estimateViewport() {
        return new CanvasSize(-50.0, 50.0, -50.0, 50.0);
    }

    @Override
    protected double[] rearrange(double[] v) {
        double[] r = new double[v.length];
        r[0] = v[this.dim1];
        r[1] = v[this.dim2];
        int ldim = Math.min(this.dim1, this.dim2);
        int hdim = Math.max(this.dim1, this.dim2);
        if (ldim > 0) {
            System.arraycopy(v, 0, r, 2, ldim);
        }
        if (hdim - ldim > 1) {
            System.arraycopy(v, ldim + 1, r, ldim + 2, hdim - (ldim + 1));
        }
        if (hdim + 1 < v.length) {
            System.arraycopy(v, hdim + 1, r, hdim + 1, v.length - (hdim + 1));
        }
        return r;
    }

    @Override
    protected double[] dearrange(double[] v) {
        double[] r = new double[v.length];
        r[this.dim1] = v[0];
        r[this.dim2] = v[1];
        int ldim = Math.min(this.dim1, this.dim2);
        int hdim = Math.max(this.dim1, this.dim2);
        if (ldim > 0) {
            System.arraycopy(v, 2, r, 0, ldim);
        }
        if (hdim - ldim > 1) {
            System.arraycopy(v, ldim + 2, r, ldim + 1, hdim - (ldim + 1));
        }
        if (hdim + 1 < v.length) {
            System.arraycopy(v, hdim + 1, r, hdim + 1, v.length - (hdim + 1));
        }
        return r;
    }

    @Override
    public String getMenuName() {
        return "Scatterplot";
    }
}

