/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class SimpleParallel
implements ProjectionParallel {
    int visDims;
    byte[] flags;
    int[] dimOrder;
    private LinearScale[] scales;
    private Projector p;
    static final byte FLAG_HIDDEN = 1;
    static final byte FLAG_INVERTED = 2;

    public SimpleParallel(Projector p, LinearScale[] scales) {
        this.p = p;
        this.scales = scales;
        this.visDims = scales.length;
        this.flags = new byte[scales.length];
        this.dimOrder = new int[scales.length];
        for (int i = 0; i < this.dimOrder.length; ++i) {
            this.dimOrder[i] = i;
        }
    }

    @Override
    public LinearScale getScale(int dim) {
        return this.scales[dim];
    }

    @Override
    public boolean isAxisInverted(int axis) {
        return this.isDimInverted(this.dimOrder[axis]);
    }

    @Override
    public void setAxisInverted(int axis, boolean bool) {
        this.setDimInverted(this.dimOrder[axis], bool);
    }

    @Override
    public void toggleAxisInverted(int axis) {
        this.toggleDimInverted(this.dimOrder[axis]);
    }

    @Override
    public boolean isDimInverted(int truedim) {
        return (this.flags[truedim] & 2) == 2;
    }

    @Override
    public void setDimInverted(int truedim, boolean bool) {
        if (bool) {
            int n = truedim;
            this.flags[n] = (byte)(this.flags[n] | 2);
        } else {
            int n = truedim;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFD);
        }
    }

    @Override
    public void toggleDimInverted(int truedim) {
        int n = truedim;
        this.flags[n] = (byte)(this.flags[n] ^ 2);
    }

    @Override
    public LinearScale getAxisScale(int axis) {
        return this.scales[this.dimOrder[axis]];
    }

    protected boolean isDimHidden(int truedim) {
        return (this.flags[truedim] & 1) == 1;
    }

    @Override
    public boolean isAxisVisible(int dim) {
        return !this.isDimHidden(this.dimOrder[dim]);
    }

    @Override
    public void setAxisVisible(int dim, boolean vis) {
        boolean prev = this.isAxisVisible(dim);
        if (prev == vis) {
            return;
        }
        if (vis) {
            int n = this.dimOrder[dim];
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
            ++this.visDims;
        } else {
            int n = this.dimOrder[dim];
            this.flags[n] = (byte)(this.flags[n] | 1);
            --this.visDims;
        }
    }

    @Override
    public void toggleAxisVisible(int dim) {
        boolean prev = this.isAxisVisible(dim);
        if (!prev) {
            int n = this.dimOrder[dim];
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
            ++this.visDims;
        } else {
            int n = this.dimOrder[dim];
            this.flags[n] = (byte)(this.flags[n] | 1);
            --this.visDims;
        }
    }

    @Override
    public int getVisibleDimensions() {
        return this.visDims;
    }

    @Override
    public int getDimForAxis(int pos) {
        return this.dimOrder[pos];
    }

    @Override
    public int getDimForVisibleAxis(int pos) {
        for (int i = 0; i < this.scales.length; ++i) {
            if (this.isDimHidden(this.dimOrder[i])) continue;
            if (pos == 0) {
                return this.dimOrder[i];
            }
            --pos;
        }
        return -1;
    }

    @Override
    public void swapAxes(int a, int b) {
        int temp = this.dimOrder[a];
        this.dimOrder[a] = this.dimOrder[b];
        this.dimOrder[b] = temp;
    }

    @Override
    public void moveAxis(int src, int dest) {
        if (src > dest) {
            int temp = this.dimOrder[src];
            System.arraycopy(this.dimOrder, dest, this.dimOrder, dest + 1, src - dest);
            this.dimOrder[dest] = temp;
        } else if (src < dest) {
            int temp = this.dimOrder[src];
            System.arraycopy(this.dimOrder, src + 1, this.dimOrder, src, dest - src);
            this.dimOrder[dest - 1] = temp;
        }
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector data) {
        double[] v = new double[this.visDims];
        int o = 0;
        for (int j = 0; j < this.scales.length; ++j) {
            if (this.isDimHidden(j)) continue;
            int i = this.dimOrder[j];
            double w = this.scales[i].getScaled(data.doubleValue(i));
            w = this.isDimInverted(i) ? w : 1.0 - w;
            v[o++] = w * 100.0;
        }
        return v;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] data) {
        double[] v = new double[this.visDims];
        int o = 0;
        for (int j = 0; j < this.scales.length; ++j) {
            if (this.isDimHidden(j)) continue;
            int i = this.dimOrder[j];
            double w = this.scales[i].getScaled(data[i]);
            w = this.isDimInverted(i) ? w : 1.0 - w;
            v[o++] = w * 100.0;
        }
        return v;
    }

    @Override
    public double fastProjectRenderToDataSpace(double v, int projdim) {
        int truedim = this.dimOrder[projdim];
        v = this.isDimInverted(truedim) ? v : 1.0 - (v /= 100.0);
        return this.scales[truedim].getUnscaled(v);
    }

    @Override
    public double fastProjectDataToRenderSpace(double value, int dim) {
        double temp = this.scales[this.dimOrder[dim]].getScaled(value);
        return this.isAxisInverted(this.dimOrder[dim]) ? 1.0 - temp : (temp *= 100.0);
    }

    @Override
    public int getAxisForDim(int truedim) {
        for (int i = 0; i < this.dimOrder.length; ++i) {
            if (this.dimOrder[i] != truedim) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getInputDimensionality() {
        return this.scales.length;
    }

    @Override
    public String getMenuName() {
        return "Parallel Coordinates";
    }

    @Override
    public Projector getProjector() {
        return this.p;
    }
}

