/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.HistogramProjector;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotFactory;

public class HistogramFactory
implements ProjectorFactory {
    private int maxdim = 10;

    public HistogramFactory(int maxdim) {
        this.maxdim = maxdim;
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(Relation.class).forEach(rel -> {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            It<Relation> it2 = context.getHierarchy().iterAncestors(rel).filter(Relation.class);
            while (it2.valid()) {
                Relation rel2 = it2.get();
                if (TypeUtil.SPATIAL_OBJECT.isAssignableFromType(rel2.getDataTypeInformation())) {
                    return;
                }
                it2.advance();
            }
            Relation vrel = rel;
            int dim = RelationUtil.dimensionality(vrel);
            HistogramProjector proj = new HistogramProjector(vrel, Math.min(dim, this.maxdim));
            context.addVis(vrel, proj);
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private int maxdim = 10;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter maxdimP = (IntParameter)new IntParameter(ScatterPlotFactory.Parameterizer.MAXDIM_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(maxdimP)) {
                this.maxdim = maxdimP.intValue();
            }
        }

        @Override
        protected HistogramFactory makeInstance() {
            return new HistogramFactory(this.maxdim);
        }
    }
}

