/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.Simple1D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.LabelVisualization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HistogramProjector<V extends NumberVector>
implements Projector {
    Relation<V> rel;
    int dmax;

    public HistogramProjector(Relation<V> rel, int maxdim) {
        this.rel = rel;
        this.dmax = maxdim;
        assert (maxdim <= RelationUtil.dimensionality(rel)) : "Requested dimensionality larger than data dimensionality?!?";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext context) {
        ArrayList<PlotItem> layout = new ArrayList<PlotItem>(1 + this.dmax);
        List<VisualizationTask> tasks = context.getVisTasks(this);
        if (!tasks.isEmpty()) {
            int d1;
            double xoff = this.dmax > 1 ? 0.1 : 0.0;
            double hheight = 0.5;
            double lheight = 0.1;
            PlotItem master = new PlotItem((double)this.dmax + xoff, 0.6, null);
            ScalesResult scales = ScalesResult.getScalesResult(this.rel);
            for (d1 = 0; d1 < this.dmax; ++d1) {
                Simple1D proj = new Simple1D(this, scales.getScales(), d1);
                PlotItem it = new PlotItem((double)d1 + xoff, 0.1, 1.0, 0.5, proj);
                it.tasks = tasks;
                master.subitems.add(it);
            }
            layout.add(master);
            for (d1 = 0; d1 < this.dmax; ++d1) {
                PlotItem it = new PlotItem((double)d1 + xoff, 0.0, 1.0, 0.1, null);
                LabelVisualization lbl = new LabelVisualization(RelationUtil.getColumnLabel(this.rel, d1));
                it.tasks.add(new VisualizationTask(lbl, "", null, null).requestSize(1.0, 0.1).with(VisualizationTask.RenderFlag.NO_DETAIL));
                master.subitems.add(it);
            }
        }
        return layout;
    }

    @Override
    public String getMenuName() {
        return "Axis plot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

