/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.OPTICSProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OPTICSProjector
implements Projector {
    private ClusterOrder clusterOrder;
    private OPTICSPlot plot = null;

    public OPTICSProjector(ClusterOrder co) {
        this.clusterOrder = co;
    }

    @Override
    public String getMenuName() {
        return "OPTICS Plot Projection";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext context) {
        ArrayList<PlotItem> col = new ArrayList<PlotItem>(1);
        List<VisualizationTask> tasks = context.getVisTasks(this);
        if (!tasks.isEmpty()) {
            PlotItem it = new PlotItem(4.0, 1.0, new OPTICSProjection(this));
            it.tasks = tasks;
            col.add(it);
        }
        return col;
    }

    public ClusterOrder getResult() {
        return this.clusterOrder;
    }

    public OPTICSPlot getOPTICSPlot(VisualizerContext context) {
        if (this.plot == null) {
            this.plot = OPTICSPlot.plotForClusterOrder(this.clusterOrder, context);
        }
        return this.plot;
    }
}

