/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;

public class ParallelPlotFactory
implements ProjectorFactory {
    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(Relation.class).forEach(rel -> {
            int dim = this.dimensionality((Relation<?>)rel);
            if (dim <= 1) {
                return;
            }
            It<Relation> it2 = context.getHierarchy().iterAncestors(rel).filter(Relation.class);
            while (it2.valid()) {
                if (this.dimensionality(it2.get()) == dim) {
                    return;
                }
                it2.advance();
            }
            Relation vrel = rel;
            ParallelPlotProjector proj = new ParallelPlotProjector(vrel);
            context.addVis(vrel, proj);
        });
    }

    private int dimensionality(Relation<?> rel) {
        if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
            Relation<?> vrel = rel;
            return RelationUtil.dimensionality(vrel);
        }
        if (UncertainObject.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
            Relation<?> vrel = rel;
            return RelationUtil.dimensionality(vrel);
        }
        return 0;
    }
}

