/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.SimpleParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Reference(authors="A. Inselberg", title="Parallel Coordinates. Visual Multidimensional Geometry and Its Applications", booktitle="", url="https://doi.org/10.1007/978-0-387-68628-8", bibkey="doi:10.1007/978-0-387-68628-8")
public class ParallelPlotProjector<V extends SpatialComparable>
implements Projector {
    Relation<V> rel;

    public ParallelPlotProjector(Relation<V> rel) {
        this.rel = rel;
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext context) {
        ArrayList<PlotItem> col = new ArrayList<PlotItem>(1);
        List<VisualizationTask> tasks = context.getVisTasks(this);
        if (!tasks.isEmpty()) {
            ScalesResult scales = ScalesResult.getScalesResult(this.rel);
            SimpleParallel proj = new SimpleParallel(this, scales.getScales());
            double width = Math.max(0.5, Math.ceil(MathUtil.log2(scales.getScales().length - 1)));
            PlotItem it = new PlotItem(width, 1.0, proj);
            it.tasks = tasks;
            col.add(it);
        }
        return col;
    }

    @Override
    public String getMenuName() {
        return "Parallelplot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

