/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;

public class ScatterPlotFactory
implements ProjectorFactory {
    public static final int MAX_DIMENSIONS_DEFAULT = 10;
    private int maxdim = 10;

    public ScatterPlotFactory(int maxdim) {
        this.maxdim = maxdim;
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(Relation.class).forEach(rel -> {
            int dim = this.dimensionality((Relation<?>)rel);
            if (dim < 1) {
                return;
            }
            It<Relation> it2 = context.getHierarchy().iterAncestors(rel).filter(Relation.class);
            while (it2.valid()) {
                if (this.dimensionality(it2.get()) == dim) {
                    return;
                }
                it2.advance();
            }
            Relation vrel = rel;
            ScatterPlotProjector proj = new ScatterPlotProjector(vrel, Math.min(this.maxdim, dim));
            context.addVis(vrel, proj);
        });
    }

    private int dimensionality(Relation<?> rel) {
        if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
            Relation<?> vrel = rel;
            return RelationUtil.dimensionality(vrel);
        }
        if (UncertainObject.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
            Relation<?> vrel = rel;
            return RelationUtil.dimensionality(vrel);
        }
        return 0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MAXDIM_ID = new OptionID("vis.maxdim", "Maximum number of dimensions to display.");
        private int maxdim = 10;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter maxdimP = (IntParameter)new IntParameter(MAXDIM_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(maxdimP)) {
                this.maxdim = maxdimP.intValue();
            }
        }

        @Override
        protected ScatterPlotFactory makeInstance() {
            return new ScatterPlotFactory(this.maxdim);
        }
    }
}

