/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.AffineProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Simple2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.LabelVisualization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScatterPlotProjector<V extends SpatialComparable>
implements Projector {
    Relation<V> rel;
    int dmax;

    public ScatterPlotProjector(Relation<V> rel, int maxdim) {
        this.rel = rel;
        this.dmax = maxdim;
        assert (maxdim <= RelationUtil.dimensionality(rel)) : "Requested dimensionality larger than data dimensionality?!?";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext context) {
        ArrayList<PlotItem> layout = new ArrayList<PlotItem>(1);
        List<VisualizationTask> tasks = context.getVisTasks(this);
        if (!tasks.isEmpty()) {
            PlotItem master;
            ScalesResult scales = ScalesResult.getScalesResult(this.rel);
            if (this.dmax == 2) {
                master = new PlotItem(2.1, 2.1, null);
                Simple2D proj = new Simple2D(this, scales.getScales(), 0, 1);
                PlotItem it = new PlotItem(0.1, 0.0, 2.0, 2.0, proj);
                it.tasks = tasks;
                master.subitems.add(it);
                PlotItem it2 = new PlotItem(0.1, 2.0, 2.0, 0.1, null);
                it2.tasks.add(new VisualizationTask(new LabelVisualization(RelationUtil.getColumnLabel(this.rel, 0)), "", null, null).requestSize(2.0, 0.1).with(VisualizationTask.RenderFlag.NO_DETAIL));
                master.subitems.add(it2);
                it2 = new PlotItem(0.0, 0.0, 0.1, 2.0, null);
                it2.tasks.add(new VisualizationTask(new LabelVisualization(RelationUtil.getColumnLabel(this.rel, 1), true), "", null, null).requestSize(0.1, 2.0).with(VisualizationTask.RenderFlag.NO_DETAIL));
                master.subitems.add(it2);
            } else {
                int d1;
                double sizeh = Math.ceil((double)(this.dmax - 1) / 2.0);
                master = new PlotItem(sizeh * 2.0 + 0.1, (double)(this.dmax - 1) + 0.1, null);
                for (d1 = 0; d1 < this.dmax - 1; ++d1) {
                    for (int d2 = d1 + 1; d2 < this.dmax; ++d2) {
                        Simple2D proj = new Simple2D(this, scales.getScales(), d1, d2);
                        PlotItem it = new PlotItem((double)d1 + 0.1, d2 - 1, 1.0, 1.0, proj);
                        it.tasks = tasks;
                        master.subitems.add(it);
                    }
                }
                if (this.dmax >= 3) {
                    AffineTransformation p = AffineProjection.axisProjection(RelationUtil.dimensionality(this.rel), 1, 2);
                    p.addRotation(0, 2, MathUtil.deg2rad(-10.0));
                    p.addRotation(1, 2, MathUtil.deg2rad(15.0));
                    AffineProjection proj = new AffineProjection(this, scales.getScales(), p);
                    PlotItem it = new PlotItem(sizeh + 0.1, 0.0, sizeh, sizeh, proj);
                    it.tasks = tasks;
                    master.subitems.add(it);
                }
                for (d1 = 0; d1 < this.dmax - 1; ++d1) {
                    PlotItem it = new PlotItem((double)d1 + 0.1, this.dmax - 1, 1.0, 0.1, null);
                    it.tasks.add(new VisualizationTask(new LabelVisualization(RelationUtil.getColumnLabel(this.rel, d1)), "", null, null).requestSize(1.0, 0.1).with(VisualizationTask.RenderFlag.NO_DETAIL));
                    master.subitems.add(it);
                }
                for (int d2 = 1; d2 < this.dmax; ++d2) {
                    PlotItem it = new PlotItem(0.0, d2 - 1, 0.1, 1.0, null);
                    it.tasks.add(new VisualizationTask(new LabelVisualization(RelationUtil.getColumnLabel(this.rel, d2), true), "", null, null).requestSize(0.1, 1.0).with(VisualizationTask.RenderFlag.NO_DETAIL));
                    master.subitems.add(it);
                }
            }
            layout.add(master);
        }
        return layout;
    }

    @Override
    public String getMenuName() {
        return "Scatterplot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

