/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.savedialog;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.BatikUtil;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SaveOptionsPanel;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;

public final class SVGSaveDialog {
    public static final String DEFAULT_TITLE = "Save as ...";
    private static final Logging LOG = Logging.getLogger(SVGSaveDialog.class);
    static final String AUTOMAGIC_FORMAT = "automatic";
    static final String[] FORMATS;
    static final String[] VISIBLE_FORMATS;

    private SVGSaveDialog() {
    }

    public static int showSaveDialog(SVGPlot plot, int width, int height) {
        int ret;
        block17: {
            JFileChooser fc = new JFileChooser(new File("."));
            fc.setDialogTitle(DEFAULT_TITLE);
            SaveOptionsPanel optionsPanel = new SaveOptionsPanel(fc, width, height);
            fc.setAccessory(optionsPanel);
            ret = fc.showSaveDialog(null);
            if (ret == 0) {
                fc.setDialogTitle("Saving... Please wait.");
                File file = fc.getSelectedFile();
                String format = optionsPanel.getSelectedFormat();
                width = optionsPanel.getSelectedWidth();
                height = optionsPanel.getSelectedHeight();
                if (format == null || AUTOMAGIC_FORMAT.equals(format)) {
                    format = SVGSaveDialog.guessFormat(file.getName());
                }
                try {
                    if (format == null) {
                        SVGSaveDialog.showError(fc, "Error saving image.", "File format not recognized.");
                        break block17;
                    }
                    if ("jpeg".equals(format) || "jpg".equals(format)) {
                        float quality = optionsPanel.getJPEGQuality();
                        plot.saveAsJPEG(file, width, height, quality);
                        break block17;
                    }
                    if ("png".equals(format)) {
                        plot.saveAsPNG(file, width, height);
                        break block17;
                    }
                    if ("ps".equals(format)) {
                        plot.saveAsPS(file);
                        break block17;
                    }
                    if ("eps".equals(format)) {
                        plot.saveAsEPS(file);
                        break block17;
                    }
                    if ("pdf".equals(format)) {
                        plot.saveAsPDF(file);
                        break block17;
                    }
                    if ("svg".equals(format)) {
                        plot.saveAsSVG(file);
                        break block17;
                    }
                    SVGSaveDialog.showError(fc, "Error saving image.", "Unsupported format: " + format);
                }
                catch (IncompatibleClassChangeError e) {
                    SVGSaveDialog.showError(fc, "Error saving image.", "It seems that your Java version is incompatible with this version of Batik and Jpeg writing. Sorry.");
                }
                catch (ClassNotFoundException e) {
                    SVGSaveDialog.showError(fc, "Error saving image.", "A class was not found when saving this image. Maybe installing Apache FOP will help (for PDF, PS and EPS output).\n" + e.toString());
                }
                catch (Exception | TransformerFactoryConfigurationError e) {
                    LOG.exception(e);
                    SVGSaveDialog.showError(fc, "Error saving image.", e.toString());
                }
            } else if (ret == -1) {
                SVGSaveDialog.showError(fc, "Error in file dialog.", "Unknown Error.");
            } else if (ret == 1) {
                // empty if block
            }
        }
        return ret;
    }

    public static String guessFormat(String name) {
        String ext = FileUtil.getFilenameExtension(name);
        for (String format : FORMATS) {
            if (!format.equalsIgnoreCase(ext)) continue;
            return ext;
        }
        return null;
    }

    public static String[] getFormats() {
        return FORMATS;
    }

    public static String[] getVisibleFormats() {
        return VISIBLE_FORMATS;
    }

    private static void showError(Component parent, String title, String msg) {
        JOptionPane.showMessageDialog(parent, msg, title, 0);
    }

    static {
        ArrayList<String> fmt = new ArrayList<String>();
        fmt.add(AUTOMAGIC_FORMAT);
        fmt.add("svg");
        ImageWriterRegistry reg = ImageWriterRegistry.getInstance();
        ImageTagRegistry tagreg = ImageTagRegistry.getRegistry();
        if (tagreg.getRegisteredMimeTypes().contains("image/png")) {
            if (reg.getWriterFor("image/png") != null) {
                fmt.add("png");
            }
            if (reg.getWriterFor("image/jpeg") != null) {
                fmt.add("jpeg");
            }
        }
        if (BatikUtil.hasFOPInstalled()) {
            fmt.add("pdf");
            fmt.add("ps");
            fmt.add("eps");
        }
        FORMATS = fmt.toArray(new String[fmt.size()]);
        fmt.remove(0);
        VISIBLE_FORMATS = fmt.toArray(new String[fmt.size()]);
    }
}

