/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.savedialog;

import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SaveOptionsPanel
extends JPanel {
    private static final String STR_CHOOSE_FORMAT = "Format";
    private static final String STR_IMAGE_WIDTH = "Width";
    private static final String STR_IMAGE_HEIGHT = "Height";
    private static final String STR_LOCK_ASPECT_RATIO = "Ratio lock";
    private static final String STR_JPEG_QUALITY = "Quality";
    private static final long serialVersionUID = 1L;
    double ratio = 1.6;
    protected JSpinner spinnerWidth;
    protected JSpinner spinnerHeight;
    protected JSpinner spinnerQual;
    protected SpinnerNumberModel modelWidth;
    protected SpinnerNumberModel modelHeight;
    protected SpinnerNumberModel modelQual;
    protected JCheckBox checkAspectRatio;
    protected JButton resetSizeButton;
    protected JComboBox<String> formatSelector;
    private JLabel labelWidth;
    private JLabel labelHeight;
    private JLabel labelQual;

    public SaveOptionsPanel(JFileChooser fc, int width, int height) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints left = new GridBagConstraints();
        GridBagConstraints right = new GridBagConstraints();
        GridBagConstraints both = new GridBagConstraints();
        left.gridx = 0;
        left.anchor = 17;
        left.ipadx = 2;
        right.gridx = 1;
        right.weightx = 1.0;
        right.anchor = 17;
        right.ipadx = 2;
        both.gridx = 0;
        both.gridwidth = 2;
        both.ipadx = 2;
        this.add((Component)new JLabel(STR_CHOOSE_FORMAT), left);
        this.formatSelector = new JComboBox<String>(SVGSaveDialog.getVisibleFormats());
        this.add(this.formatSelector, right);
        this.formatSelector.setSelectedIndex(0);
        this.formatSelector.addItemListener(e -> this.setFormat((String)e.getItem()));
        this.modelWidth = new SpinnerNumberModel(width, 0, 90000, 1);
        this.labelWidth = new JLabel(STR_IMAGE_WIDTH);
        this.add((Component)this.labelWidth, left);
        this.spinnerWidth = new JSpinner(this.modelWidth);
        this.add((Component)this.spinnerWidth, right);
        this.spinnerWidth.addChangeListener(e -> {
            if (this.checkAspectRatio.isSelected()) {
                this.spinnerHeight.setValue((int)Math.round((double)this.modelWidth.getNumber().intValue() / this.ratio));
            }
        });
        this.modelHeight = new SpinnerNumberModel(height, 0, 90000, 1);
        this.labelHeight = new JLabel(STR_IMAGE_HEIGHT);
        this.add((Component)this.labelHeight, left);
        this.spinnerHeight = new JSpinner(this.modelHeight);
        this.add((Component)this.spinnerHeight, right);
        this.spinnerHeight.addChangeListener(e -> {
            if (this.checkAspectRatio.isSelected()) {
                this.spinnerWidth.setValue((int)Math.round((double)this.modelHeight.getNumber().intValue() * this.ratio));
            }
        });
        this.ratio = (double)width / (double)height;
        this.checkAspectRatio = new JCheckBox(STR_LOCK_ASPECT_RATIO);
        this.checkAspectRatio.setSelected(true);
        this.add((Component)this.checkAspectRatio, both);
        this.modelQual = new SpinnerNumberModel(0.75, 0.1, 1.0, 0.05);
        this.labelQual = new JLabel(STR_JPEG_QUALITY);
        this.add((Component)this.labelQual, left);
        this.spinnerQual = new JSpinner(this.modelQual);
        this.add((Component)this.spinnerQual, right);
        fc.addPropertyChangeListener(e -> {
            File file;
            if (e.getPropertyName().equals("SelectedFileChangedProperty") && (file = (File)e.getNewValue()) != null && file.getName() != null) {
                this.setFormat(SVGSaveDialog.guessFormat(file.getName()));
            }
        });
        this.setFormat(SVGSaveDialog.VISIBLE_FORMATS[0]);
    }

    protected void setFormat(String format) {
        String[] formats = SVGSaveDialog.getVisibleFormats();
        int index = -1;
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equalsIgnoreCase(format)) continue;
            index = i;
            break;
        }
        if (index != this.formatSelector.getSelectedIndex() && index >= 0) {
            this.formatSelector.setSelectedIndex(index);
        }
        boolean jpeg = "jpeg".equalsIgnoreCase(format) || "jpg".equalsIgnoreCase(format);
        boolean hassize = jpeg || "png".equalsIgnoreCase(format);
        this.labelWidth.setVisible(hassize);
        this.spinnerWidth.setVisible(hassize);
        this.labelHeight.setVisible(hassize);
        this.spinnerHeight.setVisible(hassize);
        this.checkAspectRatio.setVisible(hassize);
        this.labelQual.setVisible(jpeg);
        this.spinnerQual.setVisible(jpeg);
        this.revalidate();
    }

    public String getSelectedFormat() {
        return (String)this.formatSelector.getSelectedItem();
    }

    public int getSelectedWidth() {
        return (Integer)this.modelWidth.getValue();
    }

    public int getSelectedHeight() {
        return (Integer)this.modelHeight.getValue();
    }

    public float getJPEGQuality() {
        float qual = this.modelQual.getNumber().floatValue();
        return qual > 1.0f ? 1.0f : (qual < 0.0f ? 0.0f : qual);
    }
}

