/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClusterStylingPolicy
implements ClassStylingPolicy {
    ArrayList<DBIDs> ids;
    Object2IntOpenHashMap<Cluster<?>> cmap;
    IntArrayList colors;
    Clustering<?> clustering;

    public ClusterStylingPolicy(Clustering<?> clustering, StyleLibrary style) {
        this.clustering = clustering;
        ColorLibrary colorset = style.getColorSet("plot");
        List<Cluster<?>> clusters = clustering.getAllClusters();
        this.ids = new ArrayList(clusters.size());
        this.colors = new IntArrayList(clusters.size());
        this.cmap = new Object2IntOpenHashMap(clusters.size());
        this.cmap.defaultReturnValue(-1);
        Iterator<Cluster<?>> ci = clusters.iterator();
        int i = 0;
        while (ci.hasNext()) {
            Cluster<?> c = ci.next();
            this.ids.add(DBIDUtil.ensureSet(c.getIDs()));
            this.cmap.put(c, i);
            Color col = SVGUtil.stringToColor(colorset.getColor(i));
            if (col != null) {
                this.colors.add(col.getRGB());
            } else {
                LoggingUtil.warning("Unrecognized color name: " + colorset.getColor(i));
            }
            if (!ci.hasNext()) break;
            ++i;
        }
    }

    @Override
    public int getStyleForDBID(DBIDRef id) {
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.ids.get(i).contains(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColorForDBID(DBIDRef id) {
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.ids.get(i).contains(id)) continue;
            return this.colors.getInt(i);
        }
        return 0;
    }

    @Override
    public int getMinStyle() {
        return 0;
    }

    @Override
    public int getMaxStyle() {
        return this.ids.size();
    }

    @Override
    public DBIDIter iterateClass(int cnum) {
        return this.ids.get(cnum).iter();
    }

    @Override
    public int classSize(int cnum) {
        return this.ids.get(cnum).size();
    }

    public Clustering<?> getClustering() {
        return this.clustering;
    }

    public int getStyleForCluster(Cluster<?> c) {
        return this.cmap.getInt(c);
    }

    @Override
    public String getMenuName() {
        return this.clustering.getLongName();
    }
}

