/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.colors.ListBasedColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.SolidLineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.PrettyMarkers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesBasedStyleLibrary
implements StyleLibrary {
    private static final Logging LOG = Logging.getLogger(PropertiesBasedStyleLibrary.class);
    public static final String DEFAULT_SCHEME_NAME = "Default";
    public static final String DEFAULT_SCHEME_FILENAME = "default";
    public static final String DEFAULT_PROPERTIES_EXTENSION = ".properties";
    private static final String DEFAULT_PROPERTIES_PATH = PropertiesBasedStyleLibrary.class.getPackage().getName().replace('.', File.separatorChar) + File.separatorChar;
    public static final String LIST_SEPARATOR = ",";
    public static final String PROP_LINES_LIBRARY = "lines-library";
    public static final String PROP_MARKER_LIBRARY = "marker-library";
    private Properties properties;
    private String name;
    private Map<String, Object> cache = new HashMap<String, Object>();
    private LineStyleLibrary linelib = null;
    private MarkerLibrary markerlib = null;

    public PropertiesBasedStyleLibrary() {
        this(DEFAULT_SCHEME_FILENAME, DEFAULT_SCHEME_NAME);
    }

    public PropertiesBasedStyleLibrary(String filename, String name) {
        this.properties = new Properties();
        this.name = name;
        InputStream stream = null;
        try {
            stream = FileUtil.openSystemFile(filename);
        }
        catch (FileNotFoundException e) {
            try {
                stream = FileUtil.openSystemFile(filename + DEFAULT_PROPERTIES_EXTENSION);
            }
            catch (FileNotFoundException e2) {
                try {
                    stream = FileUtil.openSystemFile(DEFAULT_PROPERTIES_PATH + filename + DEFAULT_PROPERTIES_EXTENSION);
                }
                catch (FileNotFoundException e3) {
                    throw new AbortException("Could not find style scheme file '" + filename + "' for scheme '" + name + "'!");
                }
            }
        }
        try {
            this.properties.load(stream);
        }
        catch (Exception e) {
            throw new AbortException("Error loading properties file " + filename + ".\n", e);
        }
    }

    protected String getName() {
        return this.name;
    }

    private <T> T getCached(String prefix, String postfix, Class<T> cls) {
        return cls.cast(this.cache.get(prefix + '.' + postfix));
    }

    private <T> void setCached(String prefix, String postfix, T data) {
        this.cache.put(prefix + '.' + postfix, data);
    }

    protected String getPropertyValue(String prefix, String postfix) {
        String ret = this.properties.getProperty(prefix + "." + postfix);
        if (ret != null) {
            return ret;
        }
        int pos = prefix.length();
        while (pos > 0 && (pos = prefix.lastIndexOf(46, pos - 1)) > 0) {
            ret = this.properties.getProperty(prefix.substring(0, pos) + '.' + postfix);
            if (ret == null) continue;
            return ret;
        }
        ret = this.properties.getProperty(postfix);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public String getColor(String key) {
        return this.getPropertyValue(key, "color");
    }

    @Override
    public String getBackgroundColor(String key) {
        return this.getPropertyValue(key, "background-color");
    }

    @Override
    public String getTextColor(String key) {
        return this.getPropertyValue(key, "text-color");
    }

    @Override
    public ColorLibrary getColorSet(String key) {
        ColorLibrary cl = this.getCached(key, "colorset", ColorLibrary.class);
        if (cl == null) {
            String[] colors = this.getPropertyValue(key, "colorset").split(LIST_SEPARATOR);
            cl = new ListBasedColorLibrary(colors, DEFAULT_SCHEME_NAME);
            this.setCached(key, "colorset", cl);
        }
        return cl;
    }

    @Override
    public double getLineWidth(String key) {
        Double lw = this.getCached(key, "line-width", Double.class);
        if (lw == null) {
            try {
                lw = ParseUtil.parseDouble(this.getPropertyValue(key, "line-width")) * 100.0;
            }
            catch (NullPointerException e) {
                throw new AbortException("Missing/invalid value in style library: " + key + '.' + "line-width");
            }
        }
        return lw;
    }

    @Override
    public double getTextSize(String key) {
        Double lw = this.getCached(key, "text-size", Double.class);
        if (lw == null) {
            try {
                lw = ParseUtil.parseDouble(this.getPropertyValue(key, "text-size")) * 100.0;
            }
            catch (NullPointerException e) {
                throw new AbortException("Missing/invalid value in style library: " + key + '.' + "text-size");
            }
        }
        return lw;
    }

    @Override
    public String getFontFamily(String key) {
        return this.getPropertyValue(key, "font-family");
    }

    @Override
    public double getSize(String key) {
        Double lw = this.getCached(key, "size", Double.class);
        if (lw == null) {
            try {
                lw = ParseUtil.parseDouble(this.getPropertyValue(key, "size")) * 100.0;
            }
            catch (NullPointerException e) {
                throw new AbortException("Missing/invalid value in style library: " + key + '.' + "size");
            }
        }
        return lw;
    }

    @Override
    public double getOpacity(String key) {
        Double lw = this.getCached(key, "opacity", Double.class);
        if (lw == null) {
            try {
                lw = ParseUtil.parseDouble(this.getPropertyValue(key, "opacity"));
            }
            catch (NullPointerException e) {
                throw new AbortException("Missing/invalid value in style library: " + key + '.' + "opacity");
            }
        }
        return lw;
    }

    @Override
    public LineStyleLibrary lines() {
        if (this.linelib == null) {
            String libname = this.properties.getProperty(PROP_LINES_LIBRARY, SolidLineStyleLibrary.class.getName());
            try {
                Class<?> cls;
                try {
                    cls = Class.forName(libname);
                }
                catch (ClassNotFoundException e) {
                    cls = Class.forName(LineStyleLibrary.class.getPackage().getName() + '.' + libname);
                }
                this.linelib = (LineStyleLibrary)cls.getConstructor(StyleLibrary.class).newInstance(this);
            }
            catch (Exception e) {
                LOG.exception(e);
                this.linelib = new SolidLineStyleLibrary(this);
            }
        }
        return this.linelib;
    }

    @Override
    public MarkerLibrary markers() {
        if (this.markerlib == null) {
            String libname = this.properties.getProperty(PROP_MARKER_LIBRARY, PrettyMarkers.class.getName());
            try {
                Class<?> cls;
                try {
                    cls = Class.forName(libname);
                }
                catch (ClassNotFoundException e) {
                    cls = Class.forName(MarkerLibrary.class.getPackage().getName() + '.' + libname);
                }
                this.markerlib = (MarkerLibrary)cls.getConstructor(StyleLibrary.class).newInstance(this);
            }
            catch (Exception e) {
                LOG.exception(e);
                this.markerlib = new PrettyMarkers(this);
            }
        }
        return this.markerlib;
    }
}

