/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.lines;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;

public class DashedLineStyleLibrary
implements LineStyleLibrary {
    private ColorLibrary colors;
    private double[][] dashpatterns = new double[][]{new double[0], {0.5, 0.5}, {0.25, 0.25, 0.25, 0.25}, {0.75, 0.25}, {0.7, 0.1, 0.1, 0.1}};
    private double[] solidreplacement = new double[]{0.1, 0.1};
    private int dashnum = this.dashpatterns.length;
    private String dotcolor;
    private String greycolor;

    public DashedLineStyleLibrary(StyleLibrary style) {
        this.colors = style.getColorSet("plot");
        this.dotcolor = style.getColor("plot.marker");
        this.greycolor = style.getColor("plot.grey");
    }

    @Override
    public void formatCSSClass(CSSClass cls, int style, double width, Object ... flags) {
        int styleflav;
        if (style == -2) {
            cls.setStatement("stroke", this.greycolor);
        } else if (style == -1) {
            cls.setStatement("stroke", this.dotcolor);
        } else {
            cls.setStatement("stroke", this.colors.getColor(style));
        }
        boolean interpolated = false;
        for (Object flag : flags) {
            if ("strong".equals(flag)) {
                width *= 1.5;
                continue;
            }
            if ("weak".equals(flag)) {
                cls.setStatement("stroke-opacity", ".50");
                width *= 0.75;
                continue;
            }
            if (!"interpolated".equals(flag)) continue;
            interpolated = true;
        }
        cls.setStatement("stroke-width", SVGUtil.fmt(width));
        int n = styleflav = style > 0 ? style % this.dashnum : -style % this.dashnum;
        if (!interpolated) {
            double[] pat = this.dashpatterns[styleflav];
            assert (pat.length % 2 == 0);
            if (pat.length > 0) {
                StringBuilder pattern = new StringBuilder();
                for (int i = 0; i < pat.length; ++i) {
                    if (i > 0) {
                        pattern.append(',');
                    }
                    pattern.append(SVGUtil.fmt(pat[i] * width * 30.0));
                }
                cls.setStatement("stroke-dasharray", pattern.toString());
            }
        } else {
            double[] pat = this.dashpatterns[styleflav];
            if (styleflav == 0) {
                pat = this.solidreplacement;
            }
            assert (pat.length % 2 == 0);
            if (pat.length > 0) {
                StringBuilder pattern = new StringBuilder();
                for (int i = 0; i < pat.length; ++i) {
                    if (i > 0) {
                        pattern.append(',');
                    }
                    pattern.append(SVGUtil.fmt(pat[i] * width));
                }
                cls.setStatement("stroke-dasharray", pattern.toString());
            }
        }
    }
}

