/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.lines;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;

public class SolidLineStyleLibrary
implements LineStyleLibrary {
    private ColorLibrary colors;
    private String dotcolor;
    private String greycolor;

    public SolidLineStyleLibrary(StyleLibrary style) {
        this.colors = style.getColorSet("plot");
        this.dotcolor = style.getColor("plot.marker");
        this.greycolor = style.getColor("plot.grey");
    }

    @Override
    public void formatCSSClass(CSSClass cls, int style, double width, Object ... flags) {
        if (style == -2) {
            cls.setStatement("stroke", this.greycolor);
        } else if (style == -1) {
            cls.setStatement("stroke", this.dotcolor);
        } else {
            cls.setStatement("stroke", this.colors.getColor(style));
        }
        boolean interpolated = false;
        for (Object flag : flags) {
            if ("strong".equals(flag)) {
                width *= 1.5;
                continue;
            }
            if ("weak".equals(flag)) {
                cls.setStatement("stroke-opacity", ".50");
                width *= 0.75;
                continue;
            }
            if (!"interpolated".equals(flag)) continue;
            interpolated = true;
        }
        cls.setStatement("stroke-width", SVGUtil.fmt(width));
        if (interpolated) {
            cls.setStatement("stroke-dasharray", SVGUtil.fmt(width / 100.0 * 2.0) + "," + SVGUtil.fmt(width / 100.0 * 2.0));
        }
    }
}

