/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.marker;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class PrettyMarkers
implements MarkerLibrary {
    private ColorLibrary colors;
    private static final String DEFAULT_PREFIX = "s";
    private String prefix;
    private String dotcolor;
    private String greycolor;

    public PrettyMarkers(String prefix, StyleLibrary style) {
        this.prefix = prefix;
        this.colors = style.getColorSet("plot.marker");
        this.dotcolor = style.getColor("plot.marker");
        this.greycolor = style.getColor("plot.grey");
    }

    public PrettyMarkers(StyleLibrary style) {
        this(DEFAULT_PREFIX, style);
    }

    public void plotMarker(SVGPlot plot, Element parent, double x, double y, int style, double size) {
        assert (parent != null);
        if (style == -1) {
            this.plotUncolored(plot, parent, x, y, size);
            return;
        }
        if (style == -2) {
            this.plotGray(plot, parent, x, y, size);
            return;
        }
        String cssid = this.prefix + style + "_" + (int)(100.0 * size);
        switch (style & 7) {
            case 0: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("stroke", colorstr);
                    c.setStatement("stroke-width", size / 6.0);
                    plot.addCSSClassOrLogError(c);
                }
                Element line1 = plot.svgLine(x, y - size / 2.2, x, y + size / 2.2);
                SVGUtil.setCSSClass(line1, cssid);
                parent.appendChild(line1);
                Element line2 = plot.svgLine(x - size / 2.2, y, x + size / 2.2, y);
                SVGUtil.setCSSClass(line2, cssid);
                parent.appendChild(line2);
                break;
            }
            case 1: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("stroke", colorstr);
                    c.setStatement("stroke-width", size / 6.0);
                    plot.addCSSClassOrLogError(c);
                }
                Element line1 = plot.svgLine(x - size / 2.828427, y - size / 2.828427, x + size / 2.828427, y + size / 2.828427);
                SVGUtil.setCSSClass(line1, cssid);
                parent.appendChild(line1);
                Element line2 = plot.svgLine(x - size / 2.828427, y + size / 2.828427, x + size / 2.828427, y - size / 2.828427);
                SVGUtil.setCSSClass(line2, cssid);
                parent.appendChild(line2);
                break;
            }
            case 2: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("stroke", colorstr);
                    c.setStatement("stroke-width", size / 6.0);
                    c.setStatement("fill", "none");
                    plot.addCSSClassOrLogError(c);
                }
                Element circ = plot.svgCircle(x, y, size / 2.2);
                SVGUtil.setCSSClass(circ, cssid);
                parent.appendChild(circ);
                break;
            }
            case 3: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("stroke", colorstr);
                    c.setStatement("stroke-width", size / 6.0);
                    c.setStatement("fill", "none");
                    plot.addCSSClassOrLogError(c);
                }
                Element rect = plot.svgRect(x - size / 2.4, y - size / 2.4, size / 1.2, size / 1.2);
                SVGUtil.setCSSClass(rect, cssid);
                parent.appendChild(rect);
                break;
            }
            case 4: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("stroke", colorstr);
                    c.setStatement("stroke-width", size / 6.0);
                    c.setStatement("fill", "none");
                    plot.addCSSClassOrLogError(c);
                }
                Element rect = plot.svgRect(x - size / 2.7, y - size / 2.7, size / 1.35, size / 1.35);
                SVGUtil.setCSSClass(rect, cssid);
                SVGUtil.setAtt(rect, "transform", "rotate(45," + SVGUtil.fmt(x) + "," + SVGUtil.fmt(y) + ")");
                parent.appendChild(rect);
                break;
            }
            case 5: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("fill", colorstr);
                    plot.addCSSClassOrLogError(c);
                }
                Element circ = plot.svgCircle(x, y, size * 0.5);
                SVGUtil.setCSSClass(circ, cssid);
                parent.appendChild(circ);
                break;
            }
            case 6: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("fill", colorstr);
                    plot.addCSSClassOrLogError(c);
                }
                Element rect = plot.svgRect(x - size / 2.2, y - size / 2.2, size / 1.1, size / 1.1);
                SVGUtil.setCSSClass(rect, cssid);
                parent.appendChild(rect);
                break;
            }
            case 7: {
                if (!plot.getCSSClassManager().contains(cssid)) {
                    CSSClass c = new CSSClass(this, cssid);
                    String colorstr = this.colors.getColor(style);
                    c.setStatement("fill", colorstr);
                    plot.addCSSClassOrLogError(c);
                }
                Element rect = plot.svgRect(x - size / 2.5, y - size / 2.5, size / 1.25, size / 1.25);
                SVGUtil.setCSSClass(rect, cssid);
                SVGUtil.setAtt(rect, "transform", "rotate(45," + SVGUtil.fmt(x) + "," + SVGUtil.fmt(y) + ")");
                parent.appendChild(rect);
                break;
            }
        }
    }

    protected void plotGray(SVGPlot plot, Element parent, double x, double y, double size) {
        Element marker = plot.svgCircle(x, y, size * 0.5);
        SVGUtil.setStyle(marker, "fill:" + this.greycolor);
        parent.appendChild(marker);
    }

    protected void plotUncolored(SVGPlot plot, Element parent, double x, double y, double size) {
        Element marker = plot.svgCircle(x, y, size * 0.5);
        SVGUtil.setStyle(marker, "fill:" + this.dotcolor);
        parent.appendChild(marker);
    }

    @Override
    public Element useMarker(SVGPlot plot, Element parent, double x, double y, int style, double size) {
        Element use = plot.svgElement("g");
        this.plotMarker(plot, use, x, y, style, size);
        if (parent != null) {
            parent.appendChild(use);
        }
        return use;
    }
}

