/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class SVGButton {
    public static final String DEFAULT_BUTTON_COLOR = "lightgray";
    public static final String DEFAULT_TEXT_COLOR = "black";
    private double x;
    private double y;
    private double w;
    private double h;
    private double r = Double.NaN;
    private CSSClass butcss;
    private String title = null;
    private CSSClass titlecss = null;

    public SVGButton(double x, double y, double w, double h, double r) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.r = r;
        this.butcss = new CSSClass(this, "button");
        this.butcss.setStatement("fill", DEFAULT_BUTTON_COLOR);
        this.butcss.setStatement("stroke", DEFAULT_TEXT_COLOR);
        this.butcss.setStatement("stroke-width", ".01");
    }

    public Element render(SVGPlot svgp) {
        Element tag = svgp.svgElement("g");
        Element button = svgp.svgRect(this.x, this.y, this.w, this.h);
        if (!Double.isNaN(this.r)) {
            SVGUtil.setAtt(button, "rx", this.r);
            SVGUtil.setAtt(button, "ry", this.r);
        }
        SVGUtil.setAtt(button, "style", this.butcss.inlineCSS());
        tag.appendChild(button);
        if (svgp.getIdElement("light-gradient") != null) {
            Element light = svgp.svgRect(this.x, this.y, this.w, this.h);
            if (!Double.isNaN(this.r)) {
                SVGUtil.setAtt(light, "rx", this.r);
                SVGUtil.setAtt(light, "ry", this.r);
            }
            SVGUtil.setAtt(light, "style", "fill:url(#light-gradient);fill-opacity:.5");
            tag.appendChild(light);
        }
        if (svgp.getIdElement("shadow-effect") != null) {
            button.setAttribute("filter", "url(#shadow-effect)");
        }
        if (this.title != null) {
            Element label = svgp.svgText(this.x + this.w * 0.5, this.y + this.h * 0.7, this.title);
            label.setAttribute("style", this.titlecss.inlineCSS());
            tag.appendChild(label);
        }
        return tag;
    }

    public void setTitle(String title, String textcolor) {
        this.title = title;
        if (this.titlecss == null) {
            this.titlecss = new CSSClass(this, "text");
            this.titlecss.setStatement("text-anchor", "middle");
            this.titlecss.setStatement("fill", textcolor);
            this.titlecss.setStatement("font-size", 0.6 * this.h);
        }
    }
}

